package cn.wise.sc.cement.business.model.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import java.io.Serializable;

/**
 * @description:
 * @author: qh
 * @create: 2020-09-30 14:16
 **/
@Data
@ApiModel("总产值统计")
public class ProductionVo implements Serializable {

    private static final long serialVersionUID = 42L;
    /**
     * 主键
     */
    @ApiModelProperty("用户id")
    private String userId;
    @ApiModelProperty("用户名")
    private String userName;
    @ApiModelProperty("账号")
    private String account;
    @ApiModelProperty("职位id")
    private Integer positionId;
    @ApiModelProperty("职位")
    private String position;
    @ApiModelProperty("统计时间")
    private String time;
    @ApiModelProperty("标准产值")
    private Integer productionValue = 0;
    @ApiModelProperty("非标准产值")
    private Double nonProductionValue = 0D;
    @ApiModelProperty("总产值")
    private Double productionTotalValue = 0D;
    @ApiModelProperty("部门id")
    private Integer groupId;
}
