package cn.wise.sc.cement.business.model.vo;

import cn.wise.sc.cement.business.entity.StandardValue;
import cn.wise.sc.cement.business.model.query.EnclosureQuery;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @description:
 * @author: ztw
 * @create: 2020-08-07 15:09
 **/

@Data
@ApiModel("标样Vo")
public class StandardVo {

	/**
	 * 主键
	 */
	@ApiModelProperty("标准样品表id")
	private Integer id;

	@ApiModelProperty("标准样品名称")
	private String name;

	@ApiModelProperty("标准样品代号")
	private String code;

	@ApiModelProperty("供应商表id")
	private Integer supplierId;

	@ApiModelProperty("购买厂商（经销单位）")
	private String supplierName;

	@ApiModelProperty("进样日期")
	private LocalDate purchaseDate;

	@ApiModelProperty("有效日期")
	private LocalDate validDate;

	@ApiModelProperty("存储位置")
	private String position;

	@ApiModelProperty("库存数量")
	private BigDecimal stockNum;

	@ApiModelProperty("库存提醒数量（少于多少进行提醒）")
	private BigDecimal leastNum;

	@ApiModelProperty("状态（0已作废，1启用中）")
	private Integer status;

	@ApiModelProperty("创建时间")
	private LocalDateTime createTime;

	@ApiModelProperty("备注")
	private String remark;

	@ApiModelProperty("标样材料信息")
	private List<EnclosureQuery> enclosureQueryList;

	@ApiModelProperty("标准值")
	private List<StandardValue> standardValueList;






}
