package cn.wise.sc.cement.business.service;

import cn.wise.sc.cement.business.entity.Client;
import cn.wise.sc.cement.business.model.BaseResponse;
import cn.wise.sc.cement.business.model.PageQuery;
import cn.wise.sc.cement.business.model.query.ClientQuery;
import cn.wise.sc.cement.business.model.vo.ClientVo;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.IService;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * <p>
 * 服务类
 * </p>
 *
 * @author ztw
 * @since 2020-08-07
 */
public interface IClientService extends IService<Client> {

    /**
     * 获取分页
     * @param pageQuery 分页
     * @param status 状态
     * @param region 所在地区
     * @param principal 负责人名字
     * @return IPage<ClientVo>
     */
    BaseResponse<IPage<ClientVo>> getPage(PageQuery pageQuery, Integer status, String region, String principal);

    /**
     * 获取所有启动的单位信息
     *
     * @return List
     */
    BaseResponse<List<Client>> getList();

    /**
     * 新增委托单位
     *
     * @param  query
     * @return ClientVo
     */
    BaseResponse<Client> create(ClientQuery query);

    /**
     * 更新委托单位
     *
     * @param  query
     * @return ClientVo
     */
    BaseResponse<Client> update(ClientQuery query);

    /**
     * 启用禁用
     *
     * @param status 状态
     * @param id     id
     * @return Boolean
     */
    BaseResponse<String> status(Integer status, Integer id);

	/**
	 * 委托单位导出
	 * @param status 状态
	 * @param region 所在地
	 * @param principal 联系人
	 * @param fileName 文件名称
	 * @param response
	 */
	void export(Integer status, String region, String principal, String fileName, HttpServletResponse response);
}
