package cn.wise.sc.cement.business.service;

import cn.wise.sc.cement.business.entity.HistoryArchives;
import cn.wise.sc.cement.business.model.BaseResponse;
import cn.wise.sc.cement.business.model.PageQuery;
import cn.wise.sc.cement.business.model.query.HistoryArchivesQuery;
import cn.wise.sc.cement.business.model.vo.HistoryArchivesVo;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.IService;

import java.util.List;

/**
 * <p>
 * 服务类
 * </p>
 *
 * @author wlb
 * @since 2020-09-17
 */
public interface IHistoryArchivesService extends IService<HistoryArchives> {

    /**
     * 获取分页
     * @param pageQuery 分页
     * @return IPage<CapabilityManagement>
     */
    BaseResponse<IPage<HistoryArchivesVo>> getPage(PageQuery pageQuery,Integer userId);

    /**
     * 获取所有信息
     *
     * @return List
     */
    BaseResponse<List<HistoryArchives>> getList();

    /**
     * 新增能力信息
     *
     * @param  query
     * @return HistoryArchives
     */
    BaseResponse<HistoryArchives> create(HistoryArchivesQuery query);

    /**
     * 更新能力信息
     *
     * @param  query
     * @return HistoryArchives
     */
    BaseResponse<HistoryArchives> update(HistoryArchivesQuery query);

    /**
     * 删除能力信息
     *
     * @param  id
     * @return HistoryArchives
     */
    BaseResponse delete(Integer id);

}
