package cn.wise.sc.cement.business.service.impl;

import cn.wise.sc.cement.business.entity.CapabilityManagement;
import cn.wise.sc.cement.business.mapper.CapabilityManagementMapper;
import cn.wise.sc.cement.business.model.BaseResponse;
import cn.wise.sc.cement.business.model.PageQuery;
import cn.wise.sc.cement.business.model.query.CapabilityManagementQuery;
import cn.wise.sc.cement.business.model.vo.CapabilityManagementVo;
import cn.wise.sc.cement.business.service.ICapabilityManagementService;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author wlb
 * @since 2020-09-17
 */
@Service
public class CapabilityManagementServiceImpl extends ServiceImpl<CapabilityManagementMapper, CapabilityManagement> implements ICapabilityManagementService {
    @Resource
    private CapabilityManagementMapper capabilityManagementMapper;

    @Override
    public BaseResponse<IPage<CapabilityManagementVo>> getPage (PageQuery pageQuery,Integer userId){
        Map<String,Object> map = new HashMap<>();
        map.put("userId",userId);
        Page<CapabilityManagementVo> page = new Page<>(pageQuery.getPageNo(), pageQuery.getPageSize());
        IPage<CapabilityManagementVo> pages = capabilityManagementMapper.getPage(page,map);
        return BaseResponse.okData(pages);
    }

    @Override
    public BaseResponse<List<CapabilityManagement>> getList() {
        QueryWrapper<CapabilityManagement> qw = new QueryWrapper<>();
        qw.ne("id",0);
        List<CapabilityManagement> list = this.list(qw);
        return BaseResponse.okData(list);
    }

    @Override
    @Transactional
    public BaseResponse<CapabilityManagement> create(CapabilityManagementQuery query) {
        //判断能力项名称是否重复
        QueryWrapper<CapabilityManagement> qw = new QueryWrapper<>();
        qw.eq("capability_item", query.getCapabilityItem());
        int count = capabilityManagementMapper.selectCount(qw);
        if(count>0){
            return BaseResponse.errorMsg("能力项名称已存在!");
        }
        CapabilityManagement cama = new CapabilityManagement();
        BeanUtils.copyProperties(query, cama);
        cama.setCreateTime(LocalDateTime.now());
        cama.setUpdateTime(LocalDateTime.now());
        capabilityManagementMapper.insert(cama);
        return BaseResponse.okData(cama);
    }

    @Override
    public BaseResponse<CapabilityManagement> update(CapabilityManagementQuery query) {
        QueryWrapper<CapabilityManagement> qw = new QueryWrapper<>();
        qw.eq("capability_item", query.getCapabilityItem());
        qw.ne("id",query.getId());
        int count = capabilityManagementMapper.selectCount(qw);
        if(count>0){
            return BaseResponse.errorMsg("修改此项信息!");
        }
        CapabilityManagement update = new CapabilityManagement();
        BeanUtils.copyProperties(query, update);
        update.setId(query.getId());
        capabilityManagementMapper.updateById(update);
        return BaseResponse.okData(update);
    }


    @Override
    public BaseResponse delete(Integer id) {
        CapabilityManagement camd = capabilityManagementMapper.selectById(id);
        if(camd == null){
            return BaseResponse.errorMsg("检测依据不存在");
        }
        capabilityManagementMapper.deleteById(id);
        return BaseResponse.okData("删除成功");
    }


}
