package cn.wise.sc.cement.business.service.impl;

import cn.wise.sc.cement.business.entity.HistoryArchives;
import cn.wise.sc.cement.business.mapper.HistoryArchivesMapper;
import cn.wise.sc.cement.business.model.BaseResponse;
import cn.wise.sc.cement.business.model.PageQuery;
import cn.wise.sc.cement.business.model.query.HistoryArchivesQuery;
import cn.wise.sc.cement.business.model.vo.HistoryArchivesVo;
import cn.wise.sc.cement.business.service.IHistoryArchivesService;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author wlb
 * @since 2020-09-17
 */
@Service
public class HistoryArchivesServiceImpl extends ServiceImpl<HistoryArchivesMapper, HistoryArchives> implements IHistoryArchivesService {
    @Resource
    private HistoryArchivesMapper historyArchivesMapper;

    @Override
    public BaseResponse<IPage<HistoryArchivesVo>> getPage(PageQuery pageQuery,Integer userId){
        Map<String,Object> map = new HashMap<>();
        map.put("userId",userId);
        Page<HistoryArchivesVo> page = new Page<>(pageQuery.getPageNo(), pageQuery.getPageSize());
        IPage<HistoryArchivesVo> pages = historyArchivesMapper.getPage(page,map);
        return BaseResponse.okData(pages);
    }

    @Override
    public BaseResponse<List<HistoryArchives>> getList() {
        QueryWrapper<HistoryArchives> qw = new QueryWrapper<>();
        qw.ne("id", 0);
        List<HistoryArchives> list = this.list(qw);
        return BaseResponse.okData(list);
    }



    @Override
    @Transactional
    public BaseResponse<HistoryArchives> create(HistoryArchivesQuery query) {
        QueryWrapper<HistoryArchives> qw = new QueryWrapper<>();
        qw.eq("type", query.getType());
        int count = historyArchivesMapper.selectCount(qw);
        if(count>0){
            return BaseResponse.errorMsg("类型名称已存在!");
        }
        HistoryArchives create = new HistoryArchives();
        BeanUtils.copyProperties(query, create);
        create.setCreateTime(LocalDateTime.now());
        create.setUpdateTime(LocalDateTime.now());
        historyArchivesMapper.insert(create);
        return BaseResponse.okData(create);
    }

    @Override
    public BaseResponse<HistoryArchives> update(HistoryArchivesQuery query) {
        QueryWrapper<HistoryArchives> qw = new QueryWrapper<>();
        qw.eq("type", query.getType());
        int count = historyArchivesMapper.selectCount(qw);
        if(count>0){
            return BaseResponse.errorMsg("修改此项信息!");
        }
        HistoryArchives update = new HistoryArchives();
        BeanUtils.copyProperties(query, update);
        update.setId(query.getId());
        historyArchivesMapper.updateById(update);
        return BaseResponse.okData(update);
    }

    @Override
    public BaseResponse delete(Integer id) {
        HistoryArchives delete = historyArchivesMapper.selectById(id);
        if(delete==null){
            return BaseResponse.errorMsg("检测依据不存在");
        }
        historyArchivesMapper.deleteById(id);
        return BaseResponse.okData("删除成功");
    }
}
