package cn.wise.sc.cement.business;

import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.web.client.RestTemplate;

import java.util.TimeZone;

/**
 * 启动类
 *
 * @author zhutianwei
 */
@SpringBootApplication
@EnableScheduling
@MapperScan("cn.wise.sc.cement.business.mapper")
public class TJCementApplication {

	public static void main(String[] args) {
		// 系统默认的时区
		TimeZone.setDefault(TimeZone.getTimeZone("Asia/Shanghai"));
		SpringApplication.run(TJCementApplication.class, args);
	}

	@Bean
	public RestTemplate restTemplate() {
		return new RestTemplate();
	}

}
