package cn.wise.sc.cement.business.controller;

import cn.wise.sc.cement.business.model.BaseResponse;
import cn.wise.sc.cement.business.model.PageQuery;
import cn.wise.sc.cement.business.model.query.PlanEquipmentPurchaseQuery;
import cn.wise.sc.cement.business.model.query.PlanEquipmentRepairQuery;
import cn.wise.sc.cement.business.service.IPlanEquipmentRepairService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;

/**
 * <p>
 * 前端控制器
 * </p>
 *
 * @author ztw
 * @since 2020-09-28
 */
@Api(tags = "计划管理-设备维修计划")
@RestController
@RequestMapping("/business/plan-equipment-repair")
public class PlanEquipmentRepairController {

	private static final Logger log = LoggerFactory.getLogger("PlanEquipmentRepairController");

	@Autowired
	private IPlanEquipmentRepairService equipmentRepairService;

	@ApiOperation(value = "设备维修计划分页列表")
	@ApiImplicitParams(value = {
			@ApiImplicitParam(name = "name", value = "产品名称", paramType = "query", dataType = "String")
	})
	@GetMapping("/getPage")
	public BaseResponse getPage(PageQuery pageQuery, String name) {
		try {
			return equipmentRepairService.getPage(pageQuery, name);
		} catch (Exception e) {
			log.debug("设备维修计划分页列表{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation("设备维修计划列表导出")
	@PostMapping("/export")
	public void export(String name, String fileName, HttpServletResponse response) {
		try {
			equipmentRepairService.export(name, fileName, response);
		} catch (Exception e) {
			log.debug("设备维修计划列表导出{}", e);
		}
	}

	@ApiOperation(value = "新增设备维修计划")
	@PostMapping("/create")
	public BaseResponse create(@RequestBody PlanEquipmentRepairQuery query) {
		try {
			return equipmentRepairService.create(query);
		} catch (Exception e) {
			log.debug("新增设备维修计划{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "更新设备维修计划")
	@PostMapping("/update")
	public BaseResponse update(@RequestBody PlanEquipmentRepairQuery query) {
		try {
			return equipmentRepairService.update(query);
		} catch (Exception e) {
			log.debug("更新设备维修计划{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "设备维修计划详情")
	@GetMapping("/{id}")
	public BaseResponse getDetail(@PathVariable Integer id) {
		try {
			return equipmentRepairService.getDetail(id);
		} catch (Exception e) {
			log.debug("设备维修计划详情{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "维修完成")
	@PostMapping("/finish")
	public BaseResponse finish(Integer id) {
		try {
			return equipmentRepairService.finish(id);
		} catch (Exception e) {
			log.debug("维修完成{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "删除")
	@PostMapping("/delete/{id}")
	public BaseResponse delete(@PathVariable Integer id) {
		try {
			return equipmentRepairService.delete(id);
		} catch (Exception e) {
			log.debug("删除{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}

}

