package cn.wise.sc.cement.business.controller;

import cn.wise.sc.cement.business.model.BaseResponse;
import cn.wise.sc.cement.business.model.PageQuery;
import cn.wise.sc.cement.business.model.query.PlanEquipmentPurchaseQuery;
import cn.wise.sc.cement.business.model.query.PlanStandardPurchaseQuery;
import cn.wise.sc.cement.business.service.IPlanStandardPurchaseService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;

/**
 * <p>
 * 前端控制器
 * </p>
 *
 * @author ztw
 * @since 2020-09-28
 */
@Api(tags = "计划管理-标样采购计划")
@RestController
@RequestMapping("/business/plan-standard-purchase")
public class PlanStandardPurchaseController {

	private static final Logger log = LoggerFactory.getLogger("PlanStandardPurchaseController");

	@Autowired
	private IPlanStandardPurchaseService standardPurchaseService;

	@ApiOperation(value = "标样采购计划分页列表")
	@ApiImplicitParams(value = {
			@ApiImplicitParam(name = "name", value = "产品名称", paramType = "query", dataType = "String")
	})
	@GetMapping("/getPage")
	public BaseResponse getPage(PageQuery pageQuery, String name) {
		try {
			return standardPurchaseService.getPage(pageQuery, name);
		} catch (Exception e) {
			log.debug("标样采购计划分页列表{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation("标样采购计划列表导出")
	@PostMapping("/export")
	public void export(String name, String fileName, HttpServletResponse response) {
		try {
			standardPurchaseService.export(name, fileName, response);
		} catch (Exception e) {
			log.debug("标样采购计划列表导出{}", e);
		}
	}

	@ApiOperation(value = "新增标样采购计划")
	@PostMapping("/create")
	public BaseResponse create(@RequestBody PlanStandardPurchaseQuery query) {
		try {
			return standardPurchaseService.create(query);
		} catch (Exception e) {
			log.debug("新增标样采购计划{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "更新标样采购计划")
	@PostMapping("/update")
	public BaseResponse update(@RequestBody PlanStandardPurchaseQuery query) {
		try {
			return standardPurchaseService.update(query);
		} catch (Exception e) {
			log.debug("更新标样采购计划{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "标样采购计划详情")
	@GetMapping("/{id}")
	public BaseResponse getDetail(@PathVariable Integer id) {
		try {
			return standardPurchaseService.getDetail(id);
		} catch (Exception e) {
			log.debug("标样采购计划详情{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "采购完成")
	@PostMapping("/finish")
	public BaseResponse finish(Integer id) {
		try {
			return standardPurchaseService.finish(id);
		} catch (Exception e) {
			log.debug("采购完成{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "删除")
	@PostMapping("/delete/{id}")
	public BaseResponse delete(@PathVariable Integer id) {
		try {
			return standardPurchaseService.delete(id);
		} catch (Exception e) {
			log.debug("删除{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}

}

