package cn.wise.sc.cement.business.controller;

import cn.wise.sc.cement.business.entity.Project;
import cn.wise.sc.cement.business.entity.SysPermission;
import cn.wise.sc.cement.business.entity.SysRole;
import cn.wise.sc.cement.business.model.BaseResponse;
import cn.wise.sc.cement.business.model.PageQuery;
import cn.wise.sc.cement.business.model.query.RoleQuery;
import cn.wise.sc.cement.business.model.query.UserQuery;
import cn.wise.sc.cement.business.service.ISysRoleService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 * 前端控制器
 * </p>
 *
 * @author ztw
 * @since 2020-08-20
 */
@Api(tags = "系统管理-角色管理")
@RestController
@RequestMapping("/business/sys-role")
public class SysRoleController {

	private static final Logger log = LoggerFactory.getLogger("SysRoleController");

	@Autowired
	private ISysRoleService roleService;

	@ApiOperation(value = "角色分页列表")
	@ApiImplicitParams(value = {
			@ApiImplicitParam(name = "name", value = "角色名称", paramType = "query", dataType = "String")
	})
	@GetMapping("/getPage")
	public BaseResponse getPage(PageQuery pageQuery, String name) {
		try {
			return roleService.getPage(pageQuery, name);
		} catch (Exception e) {
			log.debug("角色分页列表{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "新增角色")
	@PostMapping("/create")
	public BaseResponse create(@RequestBody RoleQuery query) {
		try {
			return roleService.create(query);
		} catch (Exception e) {
			log.debug("新增角色{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "修改角色")
	@PostMapping("/update")
	public BaseResponse update(@RequestBody RoleQuery query) {
		try {
			return roleService.update(query);
		} catch (Exception e) {
			log.debug("修改角色{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "角色详情")
	@GetMapping("/{id}")
	public BaseResponse getById(@PathVariable Integer id) {
		try {
			SysRole role = roleService.getById(id);
			if (role == null) {
				return BaseResponse.errorMsg("信息错误!");
			}
			return BaseResponse.okData(role);
		} catch (Exception e) {
			log.debug("角色详情{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "所有角色")
	@GetMapping("/getAll")
	public BaseResponse getAll() {
		try {
			List<SysRole> list = roleService.list();
			return BaseResponse.okData(list);
		} catch (Exception e) {
			log.debug("所有角色{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "根据用户id获取拥有的角色")
	@GetMapping("/byUserId")
	public BaseResponse byUserId(Integer userId) {
		try {
			return roleService.byUserId(userId);
		} catch (Exception e) {
			log.debug("根据用户id获取拥有的角色{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "删除角色")
	@PostMapping("/delete/{id}")
	public BaseResponse delete(@PathVariable Integer id) {
		try {
			return roleService.delete(id);
		} catch (Exception e) {
			log.debug("删除角色{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}

}

