package cn.wise.sc.cement.business.entity;

import cn.wise.sc.cement.business.model.BaseEntity;
import cn.wise.sc.cement.business.model.query.ClientQuery;
import cn.wise.sc.cement.business.model.vo.ClientVo;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.springframework.beans.BeanUtils;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 委托单位
 * </p>
 *
 * @author ztw
 * @since 2020-08-07
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class Client extends BaseEntity implements Serializable {

	private static final long serialVersionUID = 1L;

	@TableId(value = "id", type = IdType.AUTO)
	private Integer id;

	@ApiModelProperty("委托单位名")
	private String name;

	@ApiModelProperty("负责人")
	private String principal;

	@ApiModelProperty("负责人电话")
	private String principalPhone;

	@ApiModelProperty("所在地区:xx省xx县xx")
	private String region;

	@ApiModelProperty("状态 0:禁用 1:激活")
	private Integer status;

	@ApiModelProperty("创建时间")
	private LocalDateTime createTime;

	@ApiModelProperty("备注")
	private String remark;

}
