package cn.wise.sc.cement.business.entity;

import com.baomidou.mybatisplus.annotation.IdType;

import java.time.LocalDate;

import com.baomidou.mybatisplus.annotation.TableId;

import java.time.LocalDateTime;
import java.io.Serializable;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 *
 * </p>
 *
 * @author ztw
 * @since 2020-09-28
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class PlanEquipmentMaintain implements Serializable {

	private static final long serialVersionUID = 1L;

	/**
	 * 主键
	 */
	@TableId(value = "id", type = IdType.AUTO)
	private Integer id;

	@ApiModelProperty("产品名称")
	private String name;

	@ApiModelProperty("规格型号")
	private String model;

	@ApiModelProperty("编号")
	private String code;

	@ApiModelProperty("维护日期")
	private LocalDate maintainDate;

	@ApiModelProperty("创建人id")
	private Integer userId;

	@ApiModelProperty("设备维护人id")
	private Integer maintainerId;

	@ApiModelProperty("维护内容")
	private String maintainContent;

	@ApiModelProperty("维护结果")
	private String maintainResult;

	@ApiModelProperty("设备维护计划附件地址")
	private String enclosureUrl;

	@ApiModelProperty("附件名")
	private String alias;

	@ApiModelProperty("附件扩展名")
	private String extName;

	@ApiModelProperty("状态（0待完成，1已完成）")
	private Integer status;

	@ApiModelProperty("创建时间")
	private LocalDateTime createTime;

	@ApiModelProperty("备注")
	private String remark;
}
