package cn.wise.sc.cement.business.entity;

import java.math.BigDecimal;

import com.baomidou.mybatisplus.annotation.IdType;

import java.time.LocalDate;

import com.baomidou.mybatisplus.annotation.TableId;

import java.time.LocalDateTime;
import java.io.Serializable;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 *
 * </p>
 *
 * @author ztw
 * @since 2020-09-28
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class PlanEquipmentPurchase implements Serializable {

	private static final long serialVersionUID = 1L;

	/**
	 * 主键
	 */
	@TableId(value = "id", type = IdType.AUTO)
	private Integer id;

	@ApiModelProperty("产品名称")
	private String name;

	@ApiModelProperty("规格型号")
	private String model;

	@ApiModelProperty("技术指标")
	private String technicalIndex;

	@ApiModelProperty("单价（万元）")
	private BigDecimal unitPrice;

	@ApiModelProperty("生产单位")
	private String productionUnit;

	@ApiModelProperty("采购数量")
	private Integer purchaseNum;

	@ApiModelProperty("采购日期（购买日期）")
	private LocalDate purchaseDate;

	@ApiModelProperty("采购人id")
	private Integer purchaserId;

	@ApiModelProperty("创建人id")
	private Integer userId;

	@ApiModelProperty("状态（0待采购，1已完成）")
	private Integer status;

	@ApiModelProperty("创建时间")
	private LocalDateTime createTime;

	@ApiModelProperty("备注")
	private String remark;

}