package cn.wise.sc.cement.business.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Set;

/**
 * @description: 报告详情Vo
 * @author: qh
 * @create: 2020-10-10 09:38
 **/
@Data
@ApiModel("报告首页信息")
public class ReportDetailVo implements Serializable {

	private static final long serialVersionUID = 42L;

	@ApiModelProperty("报告编号")
	private String reportNo;
	@ApiModelProperty("送样单位")
	private String sendName;
	@ApiModelProperty("送样人")
	private String sender;
	@ApiModelProperty("送样日期")
	private String sendDate;
	@ApiModelProperty("样品数量")
	private Integer sampleNum;
	@ApiModelProperty("样品名称")
	private Set<String> sampleNames;
	@ApiModelProperty("检测类别")
	private String type = "委托";
	@ApiModelProperty("检测项目")
	private Set<String> teamNames;
	@ApiModelProperty("检测依据")
	private Set<String> methodNames;
	@ApiModelProperty("主要仪器设备(编号)")
	private Set<String> equipmentNames;
	@ApiModelProperty("项目名称")
	private String projectName;
	@ApiModelProperty("签发日期")
	private String printDate;
}
