package cn.wise.sc.cement.business.model.query;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @description:
 * @author: qh
 * @create: 2020-08-07 14:58
 **/
@Data
@ApiModel("委托请求")
public class EntrustQuery {

	@ApiModelProperty("委托表id")
	private Integer id;

	@ApiModelProperty("项目id")
	private Integer projectId;

	@ApiModelProperty("项目名称")
	private String projectName;

	@ApiModelProperty("项目编号")
	private String projectCode;

	@ApiModelProperty("委托单位id")
	private Integer clientId;

	@ApiModelProperty("送样人")
	private String sendName;

	@ApiModelProperty("送样人电话")
	private String sendPhone;

	@ApiModelProperty("委托日期")
	private LocalDate entrustDate;

	@ApiModelProperty("拟定完成日期")
	private LocalDate finishDate;

	@ApiModelProperty("样品数量")
	private Integer sampleNum;

	@ApiModelProperty("（1加急，0不加急）")
	private Integer isUrgent;

	@ApiModelProperty("剩余样品处理方法（0,取回，1由本所统一处置）")
	private Integer handleMethod;

	@ApiModelProperty("备注")
	private String remark;

	@ApiModelProperty("样品及检测项列表")
	private List<SampleTmpQuery> sampleTmpList;

}
