package cn.wise.sc.cement.business.model.query;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.RequiredArgsConstructor;

import java.time.LocalDate;

/**
 * @description: 非标产值申请
 * @author: wlb
 * @create: 2020-09-17
 **/
@Data
@RequiredArgsConstructor
@ApiModel("非标产值申请")
public class NonStandardApplyQuery {
	private Integer id;

	@ApiModelProperty(name = "reportedHours", value = "上报工时")
	private Double reportedHours;

	@ApiModelProperty(name = "workType", value = "工作类别")
	private String workType;

	@ApiModelProperty(value = "状态 0：未提交 1：待审批 2：已通过 3：未通过")
	private Integer status;

	@ApiModelProperty(name = "startTime", value = "开始时间")
	private LocalDate startTime;

	@ApiModelProperty(name = "endTime", value = "结束时间")
	private LocalDate endTime;

	@ApiModelProperty(name = "workDescription", value = "工作描述")
	private String workDescription;

	@ApiModelProperty(name = "userId", value = "用户id")
	private Integer userId;
}
