package cn.wise.sc.cement.business.model.query;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * @description:
 * @author: qh
 * @create: 2020-09-29
 **/
@Data
@ApiModel("消耗品采购计划请求")
public class PlanConsumablesPurchaseQuery {

	@ApiModelProperty("消耗品采购计划Id")
	private Integer id;

	@ApiModelProperty("产品名称")
	private String name;

	@ApiModelProperty("规格型号")
	private String model;

	@ApiModelProperty("技术指标")
	private String technicalIndex;

	@ApiModelProperty("单价（万元）")
	private BigDecimal unitPrice;

	@ApiModelProperty("生产单位")
	private String productionUnit;

	@ApiModelProperty("采购数量")
	private Integer purchaseNum;

	@ApiModelProperty("采购日期（购买日期）")
	private LocalDate purchaseDate;

	@ApiModelProperty("采购人id")
	private Integer purchaserId;

	@ApiModelProperty("备注")
	private String remark;

}
