package cn.wise.sc.cement.business.model.query;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.RequiredArgsConstructor;

import java.time.LocalDate;

/**
 * @description: 培训计划
 * @author: wlb
 * @create: 2020-10-19
 **/
@Data
@RequiredArgsConstructor
@ApiModel("培训计划")
public class PlanTrainingQuery {
	private Integer id;

	@ApiModelProperty(name = "objective", value = "培训目的/名称")
	private String objective;

	@ApiModelProperty("培训内容/类别")
	private String content;

	@ApiModelProperty("培训方式")
	private String mode;

	@ApiModelProperty("培训对象")
	private String planObject;

	@ApiModelProperty("培训人")
	private String people;

	@ApiModelProperty("考核人")
	private String assessment;

	@ApiModelProperty("培训地点")
	private String place;

	@ApiModelProperty("考核要求")
	private String requirement;

	@ApiModelProperty("联系电话")
	private String phone;

	@ApiModelProperty("开始时间")
	private LocalDate startTime;

	@ApiModelProperty("结束时间")
	private LocalDate endTime;

	@ApiModelProperty("是否提醒（0：不提醒 1：提醒）")
	private Integer remind;

	@ApiModelProperty("提醒时间")
	private LocalDate remindTime;

	/**
	 * 多个参加人员id"、"分割  如:"1、2、3"
	 */
	private String userIds;

	/**
	 * 如果是部门"、"分割  如:"12、13"
	 */
	private String groupIds;
}
