package cn.wise.sc.cement.business.model.query;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Map;

/**
 * <p>
 *
 * </p>
 *
 * @author ztw
 * @since 2020-08-24
 */
@Data
@ApiModel("数据校核-检测组信息")
public class SampleCheckTeamQuery {

	@ApiModelProperty("本所编号")
	private String cementCode;

	@ApiModelProperty("是否平行样（1是，0否）")
	private Integer isParallel;

	@ApiModelProperty("检测组id")
	private Integer teamGroupId;

	@ApiModelProperty("检测组名称")
	private String teamGroupName;

	@ApiModelProperty("主样-检测人员id")
	private Integer mainUserId;

	@ApiModelProperty("次样-检测人员id")
	private Integer secondaryUserId;

	@ApiModelProperty("主样-检测设备表id")
	private Integer mainEquipmentId;

	@ApiModelProperty("主样-检测设备名称")
	private String mainEquipmentName;

	@ApiModelProperty("次样-检测设备表id")
	private Integer secondaryEquipmentId;

	@ApiModelProperty("次样-检测设备名称")
	private String secondaryEquipmentName;

	@ApiModelProperty("主样-样品表d")
	private Integer mainSampleId;

	@ApiModelProperty("次样-样品表d")
	private Integer secondarySampleId;

	@ApiModelProperty("主样平行样编号")
	private String mainParallelCode;

	@ApiModelProperty("次样平行样编号")
	private String secondaryParallelCode;
	/**
	 * json串
	 * {"样重m":"40","K值":1.0274,"Vsio2":3.89,................}
	 */
	@ApiModelProperty("主样检测结果 Map集合")
	private Map<String, Object> mainResult;

	@ApiModelProperty("次样检测结果 Map集合")
	private Map<String, Object> secondaryResult;

	@ApiModelProperty("主样校核计算结果 Map集合")
	private Map<String, Object> mainMap;

	@ApiModelProperty("次样校核计算结果 Map集合")
	private Map<String, Object> secondaryMap;

	@ApiModelProperty("最终校核计算结果 Map集合")
	private Map<String, Object> endResult;

}
