package cn.wise.sc.cement.business.model.query;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @description:
 * @author: ztw
 * @create: 2020-08-07 14:58
 **/
@Data
@ApiModel("委托评审-样品及检测项请求")
public class SampleQuery {

	private Integer id;

	@ApiModelProperty("来样编号")
	private String sampleCode;

	@ApiModelProperty("样品名")
	private String name;

	@ApiModelProperty("样品状态（粉、块状)")
	private String sampleForm;

	@ApiModelProperty("检测项id 例子：1、2、3")
	private String teamIds;

	@ApiModelProperty("样品照片")
	private String samplePhoto;

	@ApiModelProperty("样品重量(kg)")
	private BigDecimal weight;

	@ApiModelProperty("(检测依据编号)  例子：01、23、15")
	private String methodNumbers;

	@ApiModelProperty(" 是否平行样（0否，是（2-4，代表要分成几个样品检测），）")
	private Integer isParallel;

	@ApiModelProperty("本所编号")
	private String cementCode;

	@ApiModelProperty("收费标准")
	private BigDecimal charge;

	@ApiModelProperty("产值")
	private BigDecimal outputValue;

	@ApiModelProperty("委托表id")
	private Integer entrustId;

	@ApiModelProperty("备注")
	private String remark;

}
