package cn.wise.sc.cement.business.model.vo;

import cn.wise.sc.cement.business.model.query.EnclosureQuery;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @description:
 * @author: ztw
 * @create: 2020-08-07 15:09
 **/

@Data
@ApiModel("设备报废Vo")
public class EquipmentScrapVo {

	@ApiModelProperty("设备报废表id")
	private Integer id;

	@ApiModelProperty("设备表id")
	private Integer equipmentId;

	@ApiModelProperty("设备名称")
	private String equipmentName;

	@ApiModelProperty("设备编号")
	private String code;

	@ApiModelProperty("设备品牌")
	private String brand;

	@ApiModelProperty("型号")
	private String model;

	@ApiModelProperty("购置日期")
	private LocalDate purchaseDate;

	@ApiModelProperty("资产原值")
	private String assetsValue;

	@ApiModelProperty("申请人id")
	private Integer userId;

	@ApiModelProperty("报废原因")
	private String scrapReason;

	@ApiModelProperty("报废申请日期")
	private LocalDate scrapDate;

	@ApiModelProperty("申请结果(0待审批，1已通过，2未通过)")
	private Integer status;

	@ApiModelProperty("创建时间")
	private LocalDateTime createTime;

	@ApiModelProperty("备注")
	private String remark;

}
