package cn.wise.sc.cement.business.service;

import cn.wise.sc.cement.business.entity.CapabilityManagement;
import cn.wise.sc.cement.business.model.BaseResponse;
import cn.wise.sc.cement.business.model.PageQuery;
import cn.wise.sc.cement.business.model.query.CapabilityManagementQuery;
import cn.wise.sc.cement.business.model.vo.CapabilityManagementVo;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.IService;

import java.util.List;

/**
 * <p>
 * 服务类
 * </p>
 *
 * @author wlb
 * @since 2020-09-17
 */
public interface ICapabilityManagementService extends IService<CapabilityManagement> {

	/**
	 * 获取分页
	 *
	 * @param pageQuery 分页
	 * @return IPage<CapabilityManagement>
	 */
	BaseResponse<IPage<CapabilityManagementVo>> getPage(PageQuery pageQuery, Integer userId);

	/**
	 * 获取所有信息
	 *
	 * @return List
	 */
	BaseResponse<List<CapabilityManagement>> getList();

	/**
	 * 新增能力信息
	 *
	 * @param query
	 * @return CapabilityManagementVo
	 */
	BaseResponse<CapabilityManagement> create(CapabilityManagementQuery query);

	/**
	 * 更新能力信息
	 *
	 * @param query
	 * @return CapabilityManagementVo
	 */
	BaseResponse<CapabilityManagement> update(CapabilityManagementQuery query);

	/**
	 * 删除能力信息
	 *
	 * @param id
	 * @return CapabilityManagementVo
	 */
	BaseResponse delete(Integer id);

}