package cn.wise.sc.cement.business.service;

import cn.wise.sc.cement.business.entity.NonStandardApply;
import cn.wise.sc.cement.business.model.BaseResponse;
import cn.wise.sc.cement.business.model.PageQuery;
import cn.wise.sc.cement.business.model.query.NonStandardApplyQuery;
import cn.wise.sc.cement.business.model.vo.NonStandardApplyVo;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.IService;
import io.swagger.models.auth.In;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * <p>
 * 服务类
 * </p>
 *
 * @author wlb
 * @since 2020-09-23
 */
public interface INonStandardApplyService extends IService<NonStandardApply> {
	/**
	 * 获取分页
	 *
	 * @param pageQuery 非标产值信息分页
	 * @return IPage<NoneStandardApply>
	 */
	BaseResponse<IPage<NonStandardApplyVo>> getPage(PageQuery pageQuery, String name,Integer userId);

	/**
	 * 获取所有非标产值申请信息
	 *
	 * @return List
	 */
	BaseResponse<List<NonStandardApplyVo>> getList(Integer userId);

	/**
	 * 通过id查询非标产值申请信息
	 *
	 * @return List
	 */
	BaseResponse<List<NonStandardApplyVo>> getById(Integer id);

	/**
	 * 提交申请
	 *
	 * @param query
	 * @return NoneStandardApplyVo
	 */
	BaseResponse<NonStandardApply> create(NonStandardApplyQuery query);

	/**
	 * 编辑非标产值申请信息
	 *
	 * @param query
	 * @return NoneStandardApplyVo
	 */
	BaseResponse<NonStandardApply> update(NonStandardApplyQuery query);

	/**
	 * 通过id删除指定非标产值申请信息
	 *
	 * @param id
	 * @return NoneStandardApplyVo
	 */
	BaseResponse delete(Integer id);

	/**
	 * 非标产值申请列表导出
	 *
	 * @param userId   用户id
	 * @param name     姓名
	 * @param filename 文件名
	 * @param response
	 */
	void exportList(String filename, Integer userId, String name, HttpServletResponse response);

	/**
	 * 更改状态信息，达到改变显示的效果
	 * 1：提交
	 *
	 * @param status 状态
	 * @param id     id
	 * @return Boolean
	 */
	BaseResponse<String> status(Integer status, Integer id);
}
