package cn.wise.sc.cement.business.service;

import cn.wise.sc.cement.business.entity.NormProduction;
import cn.wise.sc.cement.business.entity.NormProductionStatistics;
import cn.wise.sc.cement.business.entity.Preciprice;
import cn.wise.sc.cement.business.model.BaseResponse;
import cn.wise.sc.cement.business.model.PageQuery;
import cn.wise.sc.cement.business.model.vo.NormProductionVo;
import cn.wise.sc.cement.business.model.vo.ProductionVo;
import cn.wise.sc.cement.business.model.vo.WorkloadStatisticsVo;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;

import javax.servlet.http.HttpServletResponse;
import java.util.Date;
import java.util.List;

/**
 * <p>
 *  服务类
 * </p>
 *
 * @author ztw
 * @since 2020-11-02
 */
public interface IPrecipriceService extends IService<Preciprice> {

     boolean createPreciprice(final Integer userId, final Integer entrustId,
                                    final Integer targetId, final Integer type,
                                    final Integer sampleId);

    /**
     * 标准产值统计
     *
     * @param start 开始时间
     * @param end   结束时间
     * @param groupId  部门id
     * @return BaseResponse
     */
    BaseResponse<List<NormProductionStatistics>> normProductionStatistics(Long start, Long end, String name, Integer groupId);

    /**
     * 标准产值统计 单人详情
     *
     * @param userId 用户id
     * @param start  开始时间
     * @param end    结束时间
     * @return 详细信息
     */
    List<NormProduction.NormProductionDetail> normProductionDetails(Integer userId,
                                                                    Long start, Long end);

    /**
     * 总产值统计
     *
     * @param name 用户
     * @param start  开始时间
     * @param end    结束时间
     * @return 详细信息
     */
    List<ProductionVo> production(String name, Long start, Long end, Integer groupId);

    /**
     * 导出标准统计
     * @param start  开始时间
     * @param end 结束时间
     * @param name 人员名字
     * @param groupId  部门id
     * @param response 响应体
     */
    void exportNormProductionStatistics(Long start, Long end,String name,Integer groupId,  HttpServletResponse response);

    /**
     * 导出个人标准产值详情列表
     * @param userId 用户id
     * @param startTime 开始时间
     * @param endTime 结束时间
     * @param response 响应体
     */
    void exportNormProductionDetail(Integer userId, Long startTime, Long endTime, HttpServletResponse response);

    /**
     * 导出产值总统计列表
     * @param name 名字检索
     * @param startTime 开始时间
     * @param endTime 结束时间
     * @param response  响应体
     */
    void exportProduction(String name, Long startTime, Long endTime,Integer groupId,HttpServletResponse response);

    /**
     * 统计工作量
     * @param startTime 开始时间
     * @param endTime 结束时间
     * @return 统计对象
     */
    List<WorkloadStatisticsVo> workloadStatistics(Date startTime, Date endTime, Integer userId);
}
