package cn.wise.sc.cement.business.service;

import cn.wise.sc.cement.business.entity.Project;
import cn.wise.sc.cement.business.model.BaseResponse;
import cn.wise.sc.cement.business.model.PageQuery;
import cn.wise.sc.cement.business.model.query.ProjectQuery;
import cn.wise.sc.cement.business.model.vo.ProjectVo;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.IService;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * <p>
 * 服务类
 * </p>
 *
 * @author ztw
 * @since 2020-08-07
 */
public interface IProjectService extends IService<Project> {

	/**
	 * 获取分页
	 *
	 * @param pageQuery 分页
	 * @param clientId  委托方单位id
	 * @return IPage<ProjectVo>
	 */
	BaseResponse<IPage<ProjectVo>> getPage(PageQuery pageQuery, String code, Integer clientId, String name);

	/**
	 * 获取所有启动的项目信息
	 *
	 * @return List
	 */
	BaseResponse<List<ProjectVo>> getList();

	/**
	 * 根据委托单位id获取项目列表
	 *
	 * @param clientId
	 * @return
	 */
	BaseResponse<List<ProjectVo>> getProjectList(Integer clientId);

	/**
	 * 新增项目
	 *
	 * @param query query
	 * @return ProjectVo
	 */
	BaseResponse<Project> create(ProjectQuery query);

	/**
	 * 编辑
	 *
	 * @param query query
	 * @return ProjectVo
	 */
	BaseResponse<Project> update(ProjectQuery query);

	/**
	 * 启用禁用
	 *
	 * @param status 状态
	 * @param id     id
	 * @return Boolean
	 */
	BaseResponse<String> status(Integer status, Integer id);

	BaseResponse<ProjectVo> getByName(String name);

	/**
	 * 项目导出
	 *
	 * @param code
	 * @param clientId
	 * @param name
	 * @param fileName
	 * @param response
	 */
	void export(String code, Integer clientId, String name, String fileName, HttpServletResponse response);
}
