package cn.wise.sc.cement.business.service.impl;

import cn.wise.sc.cement.business.entity.Handle;
import cn.wise.sc.cement.business.entity.TeamGroup;
import cn.wise.sc.cement.business.mapper.HandleMapper;
import cn.wise.sc.cement.business.model.BaseResponse;
import cn.wise.sc.cement.business.model.PageQuery;
import cn.wise.sc.cement.business.service.IHandleService;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.time.LocalDateTime;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author ztw
 * @since 2020-09-10
 */
@Service
public class HandleServiceImpl extends ServiceImpl<HandleMapper, Handle> implements IHandleService {

	@Resource
	private HandleMapper handleMapper;

	/**
	 * 获取分页
	 *
	 * @param pageQuery
	 * @return
	 */
	@Override
	public BaseResponse<IPage<Handle>> getPage(PageQuery pageQuery, String name) {
		QueryWrapper<Handle> qw = new QueryWrapper<>();
		if (StringUtils.isNotEmpty(name)) {
			qw.like("name", name);
		}
		qw.orderByDesc("create_time");
		IPage<Handle> page = new Page<>(pageQuery.getPageNo(), pageQuery.getPageSize());
		page = handleMapper.selectPage(page, qw);
		return BaseResponse.okData(page);
	}

	/**
	 * 新增处理项
	 *
	 * @param query
	 * @return
	 */
	@Override
	@Transactional
	public BaseResponse<Handle> create(Handle query) {
		if (StringUtils.isEmpty(query.getName())) {
			return BaseResponse.errorMsg("处理项名称不能为空!");
		}
		QueryWrapper<Handle> qw = new QueryWrapper<>();
		qw.eq("name", query.getName());
		int count = handleMapper.selectCount(qw);
		if (count > 0) {
			return BaseResponse.errorMsg(query.getName() + "已存在");
		}
		query.setCreateTime(LocalDateTime.now());
		handleMapper.insert(query);
		return BaseResponse.okData(query);
	}

	/**
	 * 修改处理项
	 *
	 * @param query
	 * @return
	 */
	@Override
	@Transactional
	public BaseResponse<Handle> update(Handle query) {
		if (StringUtils.isEmpty(query.getName())) {
			return BaseResponse.errorMsg("处理项名称不能为空!");
		}
		QueryWrapper<Handle> qw = new QueryWrapper<>();
		qw.eq("name", query.getName());
		qw.ne("id", query.getId());
		int count = handleMapper.selectCount(qw);
		if (count > 0) {
			return BaseResponse.errorMsg(query.getName() + "已存在");
		}
		handleMapper.updateById(query);
		return BaseResponse.okData(query);
	}

}
