package cn.wise.sc.cement.business.service.impl;

import cn.wise.sc.cement.business.entity.SysApproval;
import cn.wise.sc.cement.business.entity.SysGroup;
import cn.wise.sc.cement.business.mapper.SysApprovalMapper;
import cn.wise.sc.cement.business.model.BaseResponse;
import cn.wise.sc.cement.business.model.PageQuery;
import cn.wise.sc.cement.business.model.vo.ApprovalVo;
import cn.wise.sc.cement.business.model.vo.GroupVo;
import cn.wise.sc.cement.business.service.ISysApprovalService;
import cn.wise.sc.cement.business.wrapper.page.Query;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.time.LocalDateTime;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author ztw
 * @since 2020-08-21
 */
@Service
public class SysApprovalServiceImpl extends ServiceImpl<SysApprovalMapper, SysApproval> implements ISysApprovalService {

	@Resource
	private SysApprovalMapper approvalMapper;

	/**
	 * 获取分页
	 *
	 * @param pageQuery
	 * @return
	 */
	@Override
	public BaseResponse<IPage<ApprovalVo>> getPage(PageQuery pageQuery) {
		Page<ApprovalVo> page = new Page<>(pageQuery.getPageNo(), pageQuery.getPageSize());
		IPage<ApprovalVo> pages = approvalMapper.getPage(page);
		return BaseResponse.okData(pages);
	}

	/**
	 * 新增
	 *
	 * @param query
	 * @return
	 */
	@Override
	public BaseResponse<SysApproval> create(SysApproval query) {
		if (StringUtils.isEmpty(query.getName())) {
			return BaseResponse.errorMsg("工作组名称不能为空!");
		}
		/*QueryWrapper<SysApproval> qw = new QueryWrapper<>();
		qw.eq("name", query.getName());
		int count = approvalMapper.selectCount(qw);
		if (count > 0) {
			return BaseResponse.errorMsg(query.getName() + "已存在");
		}*/
		query.setStatus(1);
		query.setCreateTime(LocalDateTime.now());
		approvalMapper.insert(query);
		return BaseResponse.okData(query);
	}

	/**
	 * 修改
	 *
	 * @param query
	 * @return
	 */
	@Override
	public BaseResponse<SysApproval> update(SysApproval query) {

		if (StringUtils.isEmpty(query.getName())) {
			return BaseResponse.errorMsg("工作组名称不能为空!");
		}
		/*QueryWrapper<SysApproval> qw = new QueryWrapper<>();
		qw.eq("name", query.getName());
		qw.ne("id", query.getId());
		int count = approvalMapper.selectCount(qw);
		if (count > 0) {
			return BaseResponse.errorMsg(query.getName() + "已存在");
		}*/
		approvalMapper.updateById(query);
		return BaseResponse.okData(query);
	}

}
