package cn.wise.sc.cement.business.service.impl;

import ch.qos.logback.classic.net.SyslogAppender;
import cn.wise.sc.cement.business.entity.SysLogs;
import cn.wise.sc.cement.business.mapper.SysLogsMapper;
import cn.wise.sc.cement.business.model.BaseResponse;
import cn.wise.sc.cement.business.model.LoginUser;
import cn.wise.sc.cement.business.model.PageQuery;
import cn.wise.sc.cement.business.model.vo.GroupVo;
import cn.wise.sc.cement.business.model.vo.LogVo;
import cn.wise.sc.cement.business.service.ISysLogsService;
import cn.wise.sc.cement.business.service.ISysUserService;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author ztw
 * @since 2020-08-24
 */
@Service
public class SysLogsServiceImpl extends ServiceImpl<SysLogsMapper, SysLogs> implements ISysLogsService {

	@Resource
	private SysLogsMapper logsMapper;
	@Autowired
	private ISysUserService userService;

	/**
	 * 分页列表
	 *
	 * @param pageQuery
	 * @param startDate
	 * @param endDate
	 * @param objType
	 * @param objId
	 * @return
	 */
	@Override
	public BaseResponse<IPage<LogVo>> getPage(PageQuery pageQuery, String startDate, String endDate, Integer objType, Integer objId) {
		Map<String, Object> params = new HashMap<>();
		params.put("startDate", startDate);
		params.put("endDate", endDate);
		params.put("objType", objType);
		params.put("objId", objId);
		Page<LogVo> page = new Page<>(pageQuery.getPageNo(), pageQuery.getPageSize());
		IPage<LogVo> pages = logsMapper.getPage(page, params);
		return BaseResponse.okData(pages);
	}

	/**
	 * 添加日志
	 *
	 * @param objType
	 * @param objId
	 * @param module
	 * @param remark
	 */
	@Transactional
	@Override
	public void saveLog(Integer objType, Integer objId, String module, String remark) {
		LoginUser loginUser = userService.getLoginUser();
		SysLogs sysLogs = new SysLogs();
		sysLogs.setUserId(loginUser.getId())
				.setObjType(objType)
				.setObjId(objId)
				.setModule(module)
				.setFlag(1)
				.setCreateTime(LocalDateTime.now())
				.setRemark(remark);
		logsMapper.insert(sysLogs);

	}

}
