package cn.wise.sc.cement.business.service.impl;

import cn.wise.sc.cement.business.entity.SysGroup;
import cn.wise.sc.cement.business.entity.SysPost;
import cn.wise.sc.cement.business.entity.SysRole;
import cn.wise.sc.cement.business.mapper.SysPostMapper;
import cn.wise.sc.cement.business.model.BaseResponse;
import cn.wise.sc.cement.business.model.PageQuery;
import cn.wise.sc.cement.business.model.query.PostQuery;
import cn.wise.sc.cement.business.model.query.RoleQuery;
import cn.wise.sc.cement.business.service.ISysPostService;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author ztw
 * @since 2020-08-25
 */
@Service
public class SysPostServiceImpl extends ServiceImpl<SysPostMapper, SysPost> implements ISysPostService {

	@Resource
	private SysPostMapper postMapper;

	/**
	 * 获取分页
	 *
	 * @param pageQuery
	 * @param name
	 * @return
	 */
	@Override
	public BaseResponse<IPage<SysPost>> getPage(PageQuery pageQuery, String name) {
		QueryWrapper<SysPost> qw = new QueryWrapper<>();
		if (StringUtils.isNotEmpty(name)) {
			qw.like("name", name);
		}
		qw.orderByDesc("create_time");
		IPage<SysPost> page = new Page<>(pageQuery.getPageNo(), pageQuery.getPageSize());
		page = postMapper.selectPage(page, qw);
		return BaseResponse.okData(page);
	}

	/**
	 * 新增职务
	 *
	 * @param query
	 * @return
	 */
	@Override
	@Transactional
	public BaseResponse<SysPost> create(PostQuery query) {
		if (StringUtils.isEmpty(query.getName())) {
			return BaseResponse.errorMsg("职务名称不能为空!");
		}
		QueryWrapper<SysPost> qw = new QueryWrapper<>();
		qw.eq("name", query.getName());
		int count = postMapper.selectCount(qw);
		if (count > 0) {
			return BaseResponse.errorMsg(query.getName() + "已存在");
		}
		SysPost post = new SysPost();
		BeanUtils.copyProperties(query, post);
		post.setStatus(1);
		post.setCreateTime(LocalDateTime.now());
		postMapper.insert(post);

		return BaseResponse.okData(post);
	}

	/**
	 * 修改职务
	 *
	 * @param query
	 * @return
	 */
	@Override
	public BaseResponse<SysPost> update(PostQuery query) {
		if (StringUtils.isEmpty(query.getName())) {
			return BaseResponse.errorMsg("职务名称不能为空!");
		}
		QueryWrapper<SysPost> qw = new QueryWrapper<>();
		qw.eq("name", query.getName());
		qw.ne("id", query.getId());
		int count = postMapper.selectCount(qw);
		if (count > 0) {
			return BaseResponse.errorMsg(query.getName() + "已存在");
		}
		SysPost post = new SysPost();
		BeanUtils.copyProperties(query, post);
		postMapper.updateById(post);
		return BaseResponse.okData(post);
	}

}
