package cn.wise.sc.cement.business.service.impl;

import cn.wise.sc.cement.business.entity.SysGroup;
import cn.wise.sc.cement.business.entity.SysPost;
import cn.wise.sc.cement.business.entity.TeamGroup;
import cn.wise.sc.cement.business.mapper.TeamGroupMapper;
import cn.wise.sc.cement.business.mapper.TeamMapper;
import cn.wise.sc.cement.business.model.BaseResponse;
import cn.wise.sc.cement.business.model.PageQuery;
import cn.wise.sc.cement.business.model.query.TeamGroupQuery;
import cn.wise.sc.cement.business.model.vo.GroupVo;
import cn.wise.sc.cement.business.service.ITeamGroupService;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.time.LocalDateTime;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author ztw
 * @since 2020-09-10
 */
@Service
public class TeamGroupServiceImpl extends ServiceImpl<TeamGroupMapper, TeamGroup> implements ITeamGroupService {

	@Resource
	private TeamGroupMapper teamGroupMapper;

	/**
	 * 获取分页
	 *
	 * @param pageQuery
	 * @return
	 */
	@Override
	public BaseResponse<IPage<TeamGroup>> getPage(PageQuery pageQuery, String name) {
		QueryWrapper<TeamGroup> qw = new QueryWrapper<>();
		if (StringUtils.isNotEmpty(name)) {
			qw.like("name", name);
		}
		qw.orderByAsc("id");
		IPage<TeamGroup> page = new Page<>(pageQuery.getPageNo(), pageQuery.getPageSize());
		page = teamGroupMapper.selectPage(page, qw);
		return BaseResponse.okData(page);
	}

	/**
	 * 新增检测项组
	 *
	 * @param query
	 * @return
	 */
	@Override
	@Transactional
	public BaseResponse<TeamGroup> create(TeamGroupQuery query) {
		if (StringUtils.isEmpty(query.getName())) {
			return BaseResponse.errorMsg("检测项组名称不能为空!");
		}
		QueryWrapper<TeamGroup> qw = new QueryWrapper<>();
		qw.eq("name", query.getName());
		int count = teamGroupMapper.selectCount(qw);
		if (count > 0) {
			return BaseResponse.errorMsg(query.getName() + "已存在");
		}
		TeamGroup teamGroup = new TeamGroup();
		BeanUtils.copyProperties(query, teamGroup);
		if (query.getCheckElement() != null && query.getCheckElement().size() > 0) {
			String checkElement = JSON.toJSON(query.getCheckElement()).toString();
			teamGroup.setCheckElement(checkElement);
		} else {
			teamGroup.setCheckElement(null);
		}
		teamGroup.setCreateTime(LocalDateTime.now());
		teamGroupMapper.insert(teamGroup);
		return BaseResponse.okData(teamGroup);
	}

	/**
	 * 修改检测项组
	 *
	 * @param query
	 * @return
	 */
	@Override
	@Transactional
	public BaseResponse<TeamGroup> update(TeamGroupQuery query) {
		if (StringUtils.isEmpty(query.getName())) {
			return BaseResponse.errorMsg("检测项组名称不能为空!");
		}
		QueryWrapper<TeamGroup> qw = new QueryWrapper<>();
		qw.eq("name", query.getName());
		qw.ne("id", query.getId());
		int count = teamGroupMapper.selectCount(qw);
		if (count > 0) {
			return BaseResponse.errorMsg(query.getName() + "已存在");
		}
		TeamGroup teamGroup = teamGroupMapper.selectById(query.getId());
		if (teamGroup == null) {
			return BaseResponse.errorMsg("数据错误!");
		}
		if (query.getCheckElement() != null && query.getCheckElement().size() > 0) {
			String checkElement = JSON.toJSON(query.getCheckElement()).toString();
			teamGroup.setCheckElement(checkElement);
		} else {
			teamGroup.setCheckElement(null);
		}
		teamGroupMapper.updateById(teamGroup);
		return BaseResponse.okData(teamGroup);
	}

}
