
package cn.wise.sc.cement.common.swagger;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

/**
 * @Auther: yangjing
 * @Date: 2020/3/29 12:17
 * @ClassName: PACKAGE_NAME
 * @Description: TODO
 */

@Configuration
@EnableSwagger2
public class SwaggerConfig extends WebMvcConfigurerAdapter {

	@Bean
	public Docket createRestApi() {// 创建API基本信息
		return new Docket(DocumentationType.SWAGGER_2)
				.apiInfo(apiInfo())
				.select()
				.apis(RequestHandlerSelectors.basePackage("cn.wise.sc.consume"))// 扫描该包下的所有需要在Swagger中展示的API，@ApiIgnore注解标注的除外
				.paths(PathSelectors.any())//egex("/api/.*") 拦截的接口路径
				.build();
	}

	private ApiInfo apiInfo() {// 创建API的基本信息，这些信息会在Swagger UI中进行显示
		return new ApiInfoBuilder()
				.title("swagger-api")// API 标题
				.description("系统接口测试对接api")// API描述
				.contact("杨**")// 联系人
				// .license("Apache License Version 2.0")// 开源协议
				.version("1.0")// 版本号
				.build();
	}

	/**
	 * 重定向静态资源的路径，千万不要注释  不然 你们在访问api的时候会404的
	 *
	 * @param registry
	 */

	@Override
	public void addResourceHandlers(ResourceHandlerRegistry registry) {
		registry.addResourceHandler("/static/**").addResourceLocations("classpath:/static/");
		registry.addResourceHandler("swagger-ui.html").addResourceLocations("classpath:/META-INF/resources/");
		registry.addResourceHandler("/webjars/**").addResourceLocations("classpath:/META-INF/resources/webjars/");
//            //下面是图片的虚拟路径配置
//            registry.addResourceHandler(fileVirtualPath+"**").
//                addResourceLocations("file:"+fileRealPath);
	}

}

