/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import asposewobfuscated.\u00eb8J;
import com.aspose.words.Document;
import com.aspose.words.PageInfo;
import com.aspose.words.PageSetup;
import com.aspose.words.PrintHelper;
import com.aspose.words.\u00ebZR;
import com.aspose.words.\u00ebZS;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.Locale;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.MediaTray;
import javax.print.attribute.standard.PageRanges;

public class AsposeWordsPrintDocument
implements Pageable,
Printable {
    private final Document \u00ebf4;
    private int \u00ebf3;
    private \u00ebZR[] \u00ebf2;
    private PageInfo \u00ebf1;
    private \u00eb8J \u00ebf0;
    private String \u00ebeZ;
    private boolean \u00ebeY = true;
    private MediaTray[] \u00ebeX;

    public AsposeWordsPrintDocument(Document document) {
        if (document == null) {
            throw new IllegalArgumentException("Document cannot be null");
        }
        this.\u00ebf4 = document;
        try {
            if (this.\u00ebrE()) {
                PageSetup pageSetup = this.\u00ebf4.getFirstSection().getPageSetup();
                this.\u00ebf2 = \u00ebZS.\u00ebO(this.\u00ebf4.getPageCount(), pageSetup.getSheetsPerBooklet(), pageSetup.getMultiplePages());
                this.\u00ebf3 = this.\u00ebf2.length;
            } else {
                this.\u00ebf3 = document.getPageCount();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void \u00ebrF() {
    }

    private boolean \u00ebrE() {
        return this.\u00ebf4.\u00ebi2().\u00ebjv();
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        if (pageIndex >= this.\u00ebf3) {
            return 1;
        }
        try {
            Graphics2D graphics2D = (Graphics2D)graphics;
            if (this.\u00ebrE()) {
                if (pageIndex < 0 || pageIndex >= this.\u00ebf2.length) {
                    throw new IllegalStateException("Unexpected Booklet signature index.");
                }
                \u00ebZR \u00ebZR10 = this.\u00ebf2[pageIndex];
                this.\u00ebf4.\u00ebZ(\u00ebZR10, this.\u00ebrD().\u00ebZJL(), this.\u00ebrD().getPaperTray(), graphics2D, (float)pageFormat.getImageableX(), (float)pageFormat.getImageableY(), (float)pageFormat.getWidth(), (float)pageFormat.getHeight());
            } else {
                this.\u00ebf4.renderToSize(pageIndex, graphics2D, (float)pageFormat.getImageableX(), (float)pageFormat.getImageableY(), (float)pageFormat.getWidth(), (float)pageFormat.getHeight());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    @Override
    public int getNumberOfPages() {
        return this.\u00ebf3;
    }

    @Override
    public PageFormat getPageFormat(int pageIndex) throws IndexOutOfBoundsException {
        PageFormat pageFormat = new PageFormat();
        try {
            PageInfo pageInfo = this.\u00ebrE() ? this.\u00ebrD() : this.\u00ebf4.getPageInfo(pageIndex);
            Paper paper = new Paper();
            float f = pageInfo.getWidthInPoints();
            float f2 = pageInfo.getHeightInPoints();
            if (pageInfo.getLandscape() && this.\u00ebeY) {
                paper.setImageableArea(0.0, 0.0, f2, f);
                paper.setSize(f2, f);
                pageFormat.setOrientation(0);
            } else {
                paper.setImageableArea(0.0, 0.0, f, f2);
                paper.setSize(f, f2);
                pageFormat.setOrientation(1);
            }
            pageFormat.setPaper(paper);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return pageFormat;
    }

    @Override
    public Printable getPrintable(int pageIndex) throws IndexOutOfBoundsException {
        return this;
    }

    void \u00ebZ(\u00eb8J \u00eb8J2) {
        this.\u00ebf0 = \u00eb8J2;
    }

    void \u00ebVR(String string) {
        this.\u00ebeZ = string;
    }

    void print() {
        PrintService printService = this.getPrintService();
        if (printService == null) {
            throw new IllegalStateException("There are no available print Services.");
        }
        try {
            int n;
            int n2;
            this.\u00ebeX = PrintHelper.getTrays(printService);
            this.\u00ebeY = this.\u00ebZ(printService);
            if (this.\u00ebf3 == 0) {
                return;
            }
            if (this.\u00ebrE()) {
                n2 = 1;
                n = this.\u00ebf3;
            } else {
                n2 = this.\u00ebf0.getFromPage() == 0 ? 1 : this.\u00ebf0.getFromPage();
                n = this.\u00ebf0.getToPage() == 0 ? this.\u00ebf3 : this.\u00ebf0.getToPage();
            }
            PageInfo pageInfo = this.\u00ebf4.getPageInfo(n2 - 1);
            int n3 = n2 - 1;
            int n4 = pageInfo.getPaperTray();
            for (int i = n2; i < n; ++i) {
                pageInfo = this.\u00ebf4.getPageInfo(i);
                int n5 = pageInfo.getPaperTray();
                if (n5 == n4) continue;
                this.\u00ebZ(printService, n3 + 1, i, n4);
                n4 = n5;
                n3 = i;
            }
            this.\u00ebZ(printService, n3 + 1, n, n4);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    void \u00ebZ(PrintService printService, int n, int n2, int n3) throws PrinterException, NoSuchFieldException, IllegalAccessException {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        printerJob.setPrintService(printService);
        printerJob.setPageable(this);
        PrintRequestAttributeSet printRequestAttributeSet = this.\u00ebf0.\u00ebvM();
        if (this.\u00ebeZ != null && this.\u00ebeZ.length() > 0) {
            printRequestAttributeSet.add(new JobName(this.\u00ebeZ, Locale.getDefault()));
        }
        printRequestAttributeSet.add(new PageRanges(n, n2));
        MediaTray mediaTray = this.\u00ebM(n3);
        if (mediaTray != null) {
            printRequestAttributeSet.add(mediaTray);
        }
        printerJob.print(printRequestAttributeSet);
    }

    MediaTray \u00ebM(Object object) throws NoSuchFieldException, IllegalAccessException {
        for (MediaTray mediaTray : this.\u00ebeX) {
            int n = PrintHelper.getTrayID(mediaTray);
            if (!object.equals(n)) continue;
            return mediaTray;
        }
        return null;
    }

    private PrintService getPrintService() {
        PrintService[] printServiceArray = PrintServiceLookup.lookupPrintServices(null, this.\u00ebf0.\u00ebvL());
        PrintService printService = PrintServiceLookup.lookupDefaultPrintService();
        if (printServiceArray.length == 0) {
            return printService;
        }
        if (printService != null) {
            for (PrintService printService2 : printServiceArray) {
                if (printService2 != printService) continue;
                return printService2;
            }
        }
        return printServiceArray[0];
    }

    private boolean \u00ebZ(PrintService printService) throws PrinterException {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        printerJob.setPrintService(printService);
        PageFormat pageFormat = printerJob.defaultPage();
        Paper paper = new Paper();
        paper.setImageableArea(0.0, 0.0, Double.MAX_VALUE, Double.MAX_VALUE);
        pageFormat.setPaper(paper);
        PageFormat pageFormat2 = printerJob.validatePage(pageFormat);
        return pageFormat.getHeight() != pageFormat2.getImageableHeight() || pageFormat.getWidth() != pageFormat2.getImageableWidth();
    }

    private PageInfo \u00ebrD() {
        if (this.\u00ebf1 == null) {
            this.\u00ebf1 = this.\u00ebf4.\u00ebrD();
        }
        return this.\u00ebf1;
    }
}

