package cn.wise.sc.cement.business.controller;

import cn.wise.sc.cement.business.entity.Cabinet;
import cn.wise.sc.cement.business.model.BaseResponse;
import cn.wise.sc.cement.business.model.PageQuery;
import cn.wise.sc.cement.business.service.ICabinetService;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

import org.springframework.web.bind.annotation.RestController;

/**
 * <p>
 * 前端控制器
 * </p>
 *
 * @author ztw
 * @since 2020-10-19
 */
@Api(tags = "存储柜子管理")
@RestController
@RequestMapping("/business/cabinet")
public class CabinetController {

	final
	ICabinetService iCabinetService;

	public CabinetController(ICabinetService iCabinetService) {
		this.iCabinetService = iCabinetService;
	}

	@PostMapping("/new")
	@ApiOperation("新增柜子")
	public BaseResponse<Boolean> newCabinet(@RequestBody Cabinet cabinet) {
		boolean save = iCabinetService.save(cabinet);
		if (save) {
			return BaseResponse.okData(true);
		} else {
			return BaseResponse.errorMsg("添加失败!");
		}
	}

	@PutMapping("/edit")
	@ApiOperation("编辑柜子")
	public BaseResponse<Boolean> editCabinet(@RequestBody Cabinet cabinet) {
		boolean b = iCabinetService.updateById(cabinet);
		if (b) {
			return BaseResponse.okData(true);
		} else {
			return BaseResponse.errorMsg("更新失败失败!");
		}
	}

	@GetMapping("/page")
	@ApiOperation("查询柜子分页")
	public BaseResponse<IPage<Cabinet>> page(PageQuery pageQuery) {
		IPage<Cabinet> page = new Page<>(pageQuery.getPageNo(), pageQuery.getPageSize());
		return BaseResponse.okData(iCabinetService.page(page));
	}

	@DeleteMapping("/{id}")
	@ApiOperation("删除柜子")
	public BaseResponse<Boolean> delete(@PathVariable("id") Integer id) {
		boolean removeById = iCabinetService.removeById(id);
		if (removeById) {
			return BaseResponse.okData(true);
		} else {
			return BaseResponse.errorMsg("删除失败!");
		}
	}
}

