package cn.wise.sc.cement.business.controller;


import cn.wise.sc.cement.business.entity.Chinastd;
import cn.wise.sc.cement.business.entity.Chinastdcode;
import cn.wise.sc.cement.business.model.BaseResponse;
import cn.wise.sc.cement.business.model.PageQuery;
import cn.wise.sc.cement.business.service.IChinastdService;
import cn.wise.sc.cement.business.service.IChinastdcodeService;
import cn.wise.sc.cement.business.util.RedisUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

import org.springframework.web.bind.annotation.RestController;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;

/**
 * <p>
 * 国标爬虫表 前端控制器
 * </p>
 *
 * @author ztw
 * @since 2020-12-09
 */
@CrossOrigin
@Api(tags = "国标")
@RestController
@RequestMapping("/business/chinastd")
public class ChinastdController {

    @Autowired
    IChinastdcodeService iChinastdcodeService;
    @Autowired
    IChinastdService iChinastdService;

    @PostMapping
    public BaseResponse<Chinastdcode> save(Chinastdcode chinastdcode) {
        iChinastdcodeService.save(chinastdcode);
        return BaseResponse.okData(chinastdcode);
    }

    @GetMapping("/page")
    @ApiOperation("标准列表")
    public BaseResponse<Page<Chinastd>> page(PageQuery pageQuery) {

        Page<Chinastd> page = new Page<>(pageQuery.getPageNo(), pageQuery.getPageSize());
        QueryWrapper<Chinastd> qw = new QueryWrapper<>();
        qw.lambda().eq(Chinastd::getInuse, 1);
        return BaseResponse.okData(iChinastdService.page(page, qw));
    }

    @GetMapping("/update/page")
    @ApiOperation("查新历史")
    public BaseResponse<Page<Chinastd>> pageUp(PageQuery pageQuery) {
        Page<Chinastd> page = new Page<>(pageQuery.getPageNo(), pageQuery.getPageSize());
        QueryWrapper<Chinastd> qw = new QueryWrapper<>();
        qw.lambda().eq(Chinastd::getInuse, 0)
                .eq(Chinastd::getStatus, "现行");
        return BaseResponse.okData(iChinastdService.page(page, qw));
    }

    @GetMapping("/all/page")
    @ApiOperation("更新记录")
    public BaseResponse<Page<Chinastd>> pageAll(PageQuery pageQuery) {
        Page<Chinastd> page = new Page<>(pageQuery.getPageNo(), pageQuery.getPageSize());
        return BaseResponse.okData(iChinastdService.page(page));
    }

    @PostMapping("/activate")
    @ApiOperation("更新记录(勾选)")
    @Transactional(rollbackFor = Exception.class)
    public BaseResponse<Boolean> update(String code) {
        if (!StringUtils.hasText(code)) {
            return BaseResponse.okData(false);
        }
        //获取前缀
        String codeStr = code.split("-")[0];
        QueryWrapper<Chinastd> qw = new QueryWrapper<>();
        qw.lambda().like(Chinastd::getCode, codeStr);
        List<Chinastd> list = iChinastdService.list(qw);
        list.forEach(arg -> {
            if (arg.getCode().equals(code)) {
                arg.setInuse(true);
            } else {
                arg.setInuse(false);
            }
        });
        return BaseResponse.okData(iChinastdService.updateBatchById(list));
    }


    @PostMapping("/chinastdcode")
    @ApiOperation("新增国标检索")
    public BaseResponse<Boolean> saveChinastdcode(@RequestBody Chinastdcode chinastdcode) {
        return BaseResponse.okData(iChinastdcodeService.save(chinastdcode));
    }

    @GetMapping("/list")
    @ApiOperation("国标检测标准列表")
    public BaseResponse<List<Chinastdcode>> list() {
        return BaseResponse.okData(iChinastdcodeService.list());
    }

    @Autowired
    RedisUtil redisUtil;

    @PostMapping("/run/sh")
    @ApiOperation("手动触发更新")
    public void run() throws IOException {
        //todo  启用线程 run()
        try {
            Process pro = Runtime.getRuntime().exec("sh /opt/chinastd_spider.sh");
            InputStream in = pro.getInputStream();
            BufferedReader read = new BufferedReader(new InputStreamReader(in));
            String line = null;
            while((line = read.readLine())!=null){
                System.out.println("#################标准查新"+line);
                redisUtil.setString("bzcx", line);
            }
            pro.waitFor();

        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @GetMapping("/getBZCXResult")
    @ApiOperation("获取标准查新的结果值 用于判断是否更新成功")
    public BaseResponse getBZCXResult()  {
        try {
            String bzcxResult = redisUtil.getString("bzcx").toString();
            return BaseResponse.okMsg("成功");

        } catch (Exception e) {
            e.printStackTrace();
        }
        return BaseResponse.errorMsg("失败");
    }







}

