package cn.wise.sc.cement.business.controller;

import cn.hutool.core.util.StrUtil;
import cn.wise.sc.cement.business.entity.Client;
import cn.wise.sc.cement.business.mapper.ClientMapper;
import cn.wise.sc.cement.business.model.BaseResponse;
import cn.wise.sc.cement.business.model.PageQuery;
import cn.wise.sc.cement.business.model.PageTableRequest;
import cn.wise.sc.cement.business.model.query.ClientQuery;
import cn.wise.sc.cement.business.service.IClientService;
import cn.wise.sc.cement.business.util.ExcelUtil;
import cn.wise.sc.cement.business.wrapper.WrapMapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * <p>
 * 前端控制器
 * </p>
 *
 * @author ztw
 * @since 2020-08-07
 */
@Api(tags = "配置管理-委托单位配置")
@RestController
@RequestMapping("/tcdri/client")
public class ClientController {

	private static final Logger log = LoggerFactory.getLogger("ClientController");

	@Autowired
	private IClientService clientService;

	@ApiOperation(value = "委托单位分页列表")
	@ApiImplicitParams(value = {
			@ApiImplicitParam(name = "status", value = "状态0:禁用 1:启用", paramType = "query", dataType = "Integer"),
			@ApiImplicitParam(name = "region", value = "所在地区", paramType = "query", dataType = "String"),
			@ApiImplicitParam(name = "principal", value = "姓名", paramType = "query", dataType = "String")
	})
	@GetMapping("/getPage")
	public BaseResponse getPage(PageQuery pageQuery, Integer status, String region, String principal) {
		try {
			return clientService.getPage(pageQuery, status, region, principal);
		} catch (Exception e) {
			log.debug("委托单位分页列表{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation("委托单位导出")
	@PostMapping("/export")
	public void export(Integer status, String region, String principal, String fileName, HttpServletResponse response) {
		try {
			clientService.export(status, region, principal, fileName, response);
		} catch (Exception e) {
			log.debug("委托单位导出{}", e);
		}
	}

	@ApiOperation(value = "委托单位详情")
	@GetMapping("/{id}")
	public BaseResponse getById(@PathVariable Integer id) {
		try {
			Client e = clientService.getById(id);
			if (e == null) {
				return BaseResponse.errorMsg("信息错误!");
			}
			return BaseResponse.okData(e);
		} catch (Exception e) {
			log.debug("委托单位详情{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "获取所有启动的单位信息")
	@GetMapping("/getList")
	public BaseResponse getList() {
		try {
			return clientService.getList();
		} catch (Exception e) {
			log.debug("获取所有启动的单位信息{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "新增委托单位")
	@PostMapping("/create")
	public BaseResponse create(@RequestBody ClientQuery clientQuery) {
		try {
			return clientService.create(clientQuery);
		} catch (Exception e) {
			log.debug("新增委托单位{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "更新委托单位")
	@PostMapping("/update")
	public BaseResponse update(@RequestBody ClientQuery clientQuery) {
		try {
			return clientService.update(clientQuery);
		} catch (Exception e) {
			log.debug("更新委托单位{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "启用禁用")
	@PostMapping("/status")
	public BaseResponse status(Integer status, Integer id) {
		try {
			return clientService.status(status, id);
		} catch (Exception e) {
			log.debug("启用禁用{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}

}

