package cn.wise.sc.cement.business.controller;

import cn.wise.sc.cement.business.entity.Consumables;
import cn.wise.sc.cement.business.entity.Equipment;
import cn.wise.sc.cement.business.model.BaseResponse;
import cn.wise.sc.cement.business.model.PageQuery;
import cn.wise.sc.cement.business.model.query.ChangeStockQuery;
import cn.wise.sc.cement.business.model.query.ChangeValidDateQuery;
import cn.wise.sc.cement.business.model.query.EquipmentQuery;
import cn.wise.sc.cement.business.service.IConsumablesService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * <p>
 * 前端控制器
 * </p>
 *
 * @author ztw
 * @since 2020-09-03
 */
@Api(tags = "资源管理-消耗品管理")
@RestController
@RequestMapping("/business/consumables")
public class ConsumablesController {

	private static final Logger log = LoggerFactory.getLogger("ConsumablesController");

	@Autowired
	private IConsumablesService consumablesService;

	@ApiOperation(value = "消耗品分页列表")
	@ApiImplicitParams(value = {
			@ApiImplicitParam(name = "name", value = "易耗品名称", paramType = "query", dataType = "String"),
			@ApiImplicitParam(name = "supplierName", value = "购买厂商名称", paramType = "query", dataType = "String")
	})
	@GetMapping("/getPage")
	public BaseResponse getPage(PageQuery pageQuery, String name, String supplierName) {
		try {
			return consumablesService.getPage(pageQuery, name, supplierName);
		} catch (Exception e) {
			log.debug("消耗品分页列表{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation("消耗品导出")
	@PostMapping("/export")
	public void export(String name, String supplierName, String fileName, HttpServletResponse response) {
		try {
			consumablesService.export(name, supplierName, fileName, response);
		} catch (Exception e) {
			log.debug("消耗品导出{}", e);
		}
	}

	@ApiOperation(value = "新增消耗品")
	@PostMapping("/create")
	public BaseResponse create(@RequestBody Consumables query) {
		try {
			return consumablesService.create(query);
		} catch (Exception e) {
			log.debug("新增消耗品{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "修改消耗品")
	@PostMapping("/update")
	public BaseResponse update(@RequestBody Consumables query) {
		try {
			return consumablesService.update(query);
		} catch (Exception e) {
			log.debug("修改消耗品{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "消耗品详情")
	@GetMapping("/{id}")
	public BaseResponse getById(@PathVariable Integer id) {
		try {
			Consumables consumables = consumablesService.getById(id);
			return BaseResponse.okData(consumables);
		} catch (Exception e) {
			log.debug("消耗品详情{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "消耗品列表")
	@GetMapping("/getList")
	public BaseResponse getList() {
		try {
			List<Consumables> list = consumablesService.list();
			return BaseResponse.okData(list);
		} catch (Exception e) {
			log.debug("消耗品列表{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "删除消耗品")
	@PostMapping("/delete/{id}")
	public BaseResponse delete(@PathVariable Integer id) {
		try {
			consumablesService.removeById(id);
			return BaseResponse.okData("删除成功");
		} catch (Exception e) {
			log.debug("删除消耗品{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "新增入库")
	@PostMapping("/enter")
	public BaseResponse enter(@RequestBody ChangeStockQuery query) {
		try {
			return consumablesService.enter(query);
		} catch (Exception e) {
			log.debug("新增入库{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "领用出库")
	@PostMapping("/out")
	public BaseResponse out(@RequestBody ChangeStockQuery query) {
		try {
			return consumablesService.out(query);
		} catch (Exception e) {
			log.debug("领用出库{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "变更有效期")
	@PostMapping("/changeValidDate")
	public BaseResponse changeValidDate(@RequestBody ChangeValidDateQuery query) {
		try {
			return consumablesService.changeValidDate(query);
		} catch (Exception e) {
			log.debug("变更有效期{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "过期处置")
	@PostMapping("/overdue")
	public BaseResponse overdue(Integer id) {
		try {
			return consumablesService.overdue(id);
		} catch (Exception e) {
			log.debug("过期处置{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}

}

