package cn.wise.sc.cement.business.controller;

import cn.wise.sc.cement.business.model.BaseResponse;
import cn.wise.sc.cement.business.model.PageQuery;
import cn.wise.sc.cement.business.model.query.CountItemDistributionQuery;
import cn.wise.sc.cement.business.model.vo.ItemDistributionVo;
import cn.wise.sc.cement.business.service.IDataStatisticsService;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;

/**
 * <p>
 * 前端控制器
 * </p>
 *
 * @author ztw
 * @since 2021-01-12
 */
@Api(tags = "数据统计")
@RestController
@RequestMapping("/business/dataStatistics")
public class DataStatisticsController {

	private static final Logger log = LoggerFactory.getLogger("DataStatisticsController");

	@Autowired
	private IDataStatisticsService dataStatisticsService;


	@ApiOperation(value = "统计概览-重要数值统计")
	@GetMapping("/countOverview")
	public BaseResponse countOverview() {
		try {
			return dataStatisticsService.countOverview();
		} catch (Exception e) {
			log.debug("统计概览-重要数值统计{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "统计概览-检测项数量统计")
	@ApiImplicitParams(value = {
			@ApiImplicitParam(name = "type", value = "类型1:按时间 2:按地区", paramType = "query", dataType = "Integer"),
			@ApiImplicitParam(name = "cycle", value = "统计周期1:本周 2:本月 3:本年", paramType = "query", dataType = "Integer"),
			@ApiImplicitParam(name = "startDate", value = "开始日期", paramType = "query", dataType = "String"),
			@ApiImplicitParam(name = "endDate", value = "结束日期", paramType = "query", dataType = "String")
	})
	@GetMapping("/countTeam")
	public BaseResponse countTeam(Integer type, Integer cycle, String startDate, String endDate) {
		try {
			if(type == 1){
				return dataStatisticsService.countTeamByTime(cycle, startDate,endDate);
			}else if(type == 2){
				return dataStatisticsService.countTeamByOrigin(cycle, startDate,endDate);
			}else{
				return BaseResponse.errorMsg("参数错误");
			}
		} catch (Exception e) {
			log.debug("统计概览-检测项数量统计{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "统计概览-项目进展统计")
	@ApiImplicitParams(value = {
			@ApiImplicitParam(name = "cycle", value = "统计周期1:本周 2:本月 3:本年", paramType = "query", dataType = "Integer"),
			@ApiImplicitParam(name = "startDate", value = "开始日期", paramType = "query", dataType = "String"),
			@ApiImplicitParam(name = "endDate", value = "结束日期", paramType = "query", dataType = "String")
	})
	@GetMapping("/countEntrustStatus")
	public BaseResponse countEntrustStatus(Integer cycle, String startDate, String endDate) {
		try {
			return dataStatisticsService.countEntrustStatus(cycle, startDate, endDate);
		} catch (Exception e) {
			log.debug("统计概览-项目进展统计{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}


	@ApiOperation(value = "项目进展统计-列表")
	@ApiImplicitParams(value = {
			@ApiImplicitParam(name = "type", value = "类型1:按时间 2:按地区", paramType = "query", dataType = "Integer"),
			@ApiImplicitParam(name = "cycle", value = "统计周期1:本周 2:本月 3:本年", paramType = "query", dataType = "Integer"),
			@ApiImplicitParam(name = "startDate", value = "开始日期", paramType = "query", dataType = "String"),
			@ApiImplicitParam(name = "endDate", value = "结束日期", paramType = "query", dataType = "String")
	})
	@GetMapping("/countEntrustPage")
	public BaseResponse countEntrustPage(PageQuery pageQuery) {
		try {
			return dataStatisticsService.countEntrustPage(pageQuery);
		} catch (Exception e) {
			log.debug("项目进展统计-列表{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "统计概览-进行中任务数量统计")
	@GetMapping("/countTaskIng")
	public BaseResponse countTaskIng(PageQuery pageQuery) {
		try {
			return dataStatisticsService.countTaskIng(pageQuery);
		} catch (Exception e) {
			log.debug("统计概览-进行中任务数量统计{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}


	@ApiOperation(value = "统计概览-正在进行的检测项统计")
	@GetMapping("/countTeamIng")
	public BaseResponse countTeamIng() {
		try {
			return dataStatisticsService.countTeamIng();
		} catch (Exception e) {
			log.debug("统计概览-正在进行的检测项统计{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}


	@ApiOperation(value = "检测项数量统计-检测项数量统计")
	@GetMapping("/countTeamDetail")
	public BaseResponse countTeamDetail(Integer cycle, String startDate, String endDate) {
		try {
			return dataStatisticsService.countTeamDetail(cycle, startDate, endDate);
		} catch (Exception e) {
			log.debug("检测项数量统计-检测项数量统计{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}


	@ApiOperation(value = "检测项数量统计-列表")
	@GetMapping("/countTeamList")
	public BaseResponse countTeamList() {
		try {
			return dataStatisticsService.countTeamList();
		} catch (Exception e) {
			log.debug("检测项数量统计-列表{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}

    @ApiOperation("检测项分布统计")
    @PostMapping("/item/download")
    public BaseResponse<Page<ItemDistributionVo>> downloadItemDistribution(@RequestBody CountItemDistributionQuery query, HttpServletResponse response) {
        return dataStatisticsService.countItemDistribution(query, response);
    }


}

