package cn.wise.sc.cement.business.controller;

import cn.wise.sc.cement.business.entity.Handle;
import cn.wise.sc.cement.business.entity.Method;
import cn.wise.sc.cement.business.entity.TeamGroup;
import cn.wise.sc.cement.business.model.BaseResponse;
import cn.wise.sc.cement.business.model.PageQuery;
import cn.wise.sc.cement.business.model.query.MethodQuery;
import cn.wise.sc.cement.business.model.vo.HandleVo;
import cn.wise.sc.cement.business.service.IHandleService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * <p>
 * 前端控制器
 * </p>
 *
 * @author ztw
 * @since 2020-09-10
 */
@Api(tags = "配置管理-处理项配置")
@RestController
@RequestMapping("/business/handle")
public class HandleController {

	private static final Logger log = LoggerFactory.getLogger("HandleController");

	@Autowired
	private IHandleService handleService;

	@ApiOperation(value = "处理项分页列表")
	@ApiImplicitParams(value = {
			@ApiImplicitParam(name = "name", value = "处理项名称", paramType = "query", dataType = "String"),
			@ApiImplicitParam(name = "userName", value = "处理人姓名", paramType = "query", dataType = "String")
	})
	@GetMapping("/getPage")
	public BaseResponse getPage(PageQuery pageQuery, String name, String userName) {
		try {
			return handleService.getPage(pageQuery, name, userName);
		} catch (Exception e) {
			log.debug("处理项分页列表{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "处理项详情")
	@GetMapping("/{id}")
	public BaseResponse getById(@PathVariable Integer id) {
		try {
			return handleService.getDetail(id);
		} catch (Exception e) {
			log.debug("处理项详情{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "处理项列表")
	@GetMapping("/getList")
	public BaseResponse getList() {
		try {
			List<Handle> list = handleService.list();
			return BaseResponse.okData(list);
		} catch (Exception e) {
			log.debug("处理项列表{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "新增处理项")
	@PostMapping("/create")
	@Transactional
	public BaseResponse create(@RequestBody Handle query) {
		try {
			return handleService.create(query);
		} catch (Exception e) {
			log.debug("新增处理项{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "更新处理项")
	@PostMapping("/update")
	@Transactional
	public BaseResponse update(@RequestBody Handle query) {
		try {
			return handleService.update(query);
		} catch (Exception e) {
			log.debug("更新处理项{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "删除处理项")
	@PostMapping("/delete/{id}")
	public BaseResponse delete(@PathVariable Integer id) {
		try {
			return handleService.delete(id);
		} catch (Exception e) {
			log.debug("删除处理项{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}

}

