package cn.wise.sc.cement.business.controller;

import cn.wise.sc.cement.business.entity.Method;
import cn.wise.sc.cement.business.entity.Team;
import cn.wise.sc.cement.business.model.BaseResponse;
import cn.wise.sc.cement.business.model.PageQuery;
import cn.wise.sc.cement.business.model.query.MethodQuery;
import cn.wise.sc.cement.business.model.query.TeamQuery;
import cn.wise.sc.cement.business.service.IMethodService;
import cn.wise.sc.cement.business.service.ITeamService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;

/**
 * <p>
 * 前端控制器
 * </p>
 *
 * @author ztw
 * @since 2020-08-18
 */
@Api(tags = "配置管理-检测依据配置")
@RestController
@RequestMapping("/business/method")
public class MethodController {
	private static final Logger log = LoggerFactory.getLogger("MethodController");

	@Autowired
	private IMethodService methodService;

	@ApiOperation(value = "检测依据分页列表")
	@ApiImplicitParams(value = {
			@ApiImplicitParam(name = "name", value = "检测依据名称", paramType = "query", dataType = "String"),
			@ApiImplicitParam(name = "standard", value = "依据号", paramType = "query", dataType = "String")
	})
	@GetMapping("/getPage")
	public BaseResponse getPage(PageQuery pageQuery, String name, String standard) {
		try {
			return methodService.getPage(pageQuery, name, standard);
		} catch (Exception e) {
			log.debug("检测依据分页列表{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation("检测依据导出")
	@PostMapping("/export")
	public void export(String name, String standard, String fileName, HttpServletResponse response) {
		try {
			methodService.export(name, standard, fileName, response);
		} catch (Exception e) {
			log.debug("检测依据导出{}", e);
		}
	}

	@ApiOperation(value = "检测依据详情")
	@GetMapping("/{id}")
	public BaseResponse getById(@PathVariable Integer id) {
		try {
			Method e = methodService.getById(id);
			if (e == null) {
				return BaseResponse.errorMsg("信息错误!");
			}
			return BaseResponse.okData(e);
		} catch (Exception e) {
			log.debug("检测依据详情{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "检测依据列表")
	@GetMapping("/getList")
	public BaseResponse getList() {
		try {
			return methodService.getList();
		} catch (Exception e) {
			log.debug("检测依据列表{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "新增检测依据")
	@PostMapping("/create")
	@Transactional
	public BaseResponse create(@RequestBody MethodQuery query) {
		try {
			return methodService.create(query);
		} catch (Exception e) {
			log.debug("新增检测依据{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "更新检测依据")
	@PostMapping("/update")
	@Transactional
	public BaseResponse update(@RequestBody MethodQuery query) {
		try {
			return methodService.update(query);
		} catch (Exception e) {
			log.debug("更新检测依据{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "删除检测依据")
	@PostMapping("/delete/{id}")
	public BaseResponse delete(@PathVariable Integer id) {
		try {
			return methodService.delete(id);
		} catch (Exception e) {
			log.debug("删除检测依据{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}

}

