package cn.wise.sc.cement.business.controller;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import cn.wise.sc.cement.business.entity.NonStandardValue;
import cn.wise.sc.cement.business.model.BaseResponse;
import cn.wise.sc.cement.business.model.PageQuery;
import cn.wise.sc.cement.business.model.vo.NonStandardApplyVo;
import cn.wise.sc.cement.business.model.vo.NonStandardValueVo;
import cn.wise.sc.cement.business.service.INonStandardValueService;
import cn.wise.sc.cement.business.util.PageUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import javax.xml.crypto.Data;
import java.util.Date;
import java.util.List;

/**
 * <p>
 * 前端控制器
 * </p>
 *
 * @author wlb
 * @since 2020-09-23
 */
@Api(tags = "非标产值-非标产值")
@RestController
@RequestMapping("/tcdri/nonestandard_value")
public class NonStandardValueController {
	private static final Logger log = LoggerFactory.getLogger("NoneStandardValueController");

	@Autowired
	private INonStandardValueService inonStandardValueService;

	@ApiOperation(value = "非标产值分页")
	@GetMapping("/getPage")
	public BaseResponse getPage(PageQuery pageQuery, Integer userId, String name,String start, String end) {
		try {
			Date startParse = null;
			if (StrUtil.isNotBlank(start)) {
				startParse = DateUtil.parse(start);
			}
			Date endParse = null;
			if (StrUtil.isNotBlank(end)) {
				endParse = DateUtil.parse(end);
			}
			return inonStandardValueService.getPage(pageQuery, userId, name,startParse,endParse);
		} catch (Exception e) {
			log.debug("非标产值分页列表{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@GetMapping("/user_id")
	@ApiOperation("非标产值统计")
	public BaseResponse nonValue(PageQuery pageQuery, String start, String end, Integer groups,String name) {
		Date startParse = null;
		if (StrUtil.isNotBlank(start)) {
			startParse = DateUtil.parse(start);
		}
		Date endParse = null;
		if (StrUtil.isNotBlank(end)) {
			endParse = DateUtil.parse(end);
		}
		//将list拆分成分页
		BaseResponse<List<NonStandardValue>> baseResponse = inonStandardValueService.nonValue(startParse, endParse, groups,name);
		List<NonStandardValue> data = baseResponse.getData();
		if (data.size() != 0) {
			Page<NonStandardValue> rts = PageUtil.listConvertToPage(data, pageQuery);
			return BaseResponse.okData(rts);
		}
		return baseResponse;
	}

	@ApiOperation(value = "获取所有已通过的非标产值")
	@GetMapping("/getList")
	public BaseResponse getList(String start, String end, Integer groups,String name) {
		Date startParse = null;
		if (StrUtil.isNotBlank(start)) {
			startParse = DateUtil.parse(start);
		}
		Date endParse = null;
		if (StrUtil.isNotBlank(end)) {
			endParse = DateUtil.parse(end);
		}
		try {
			return inonStandardValueService.getList(startParse, endParse, groups,name);
		} catch (Exception e) {
			log.debug("获取所有已通过的非标产值{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}

//	@ApiOperation(value = "根据用户id查询指定非标产值信息")
//	@GetMapping("/{userId}")
//	public BaseResponse getByUserId(@PathVariable Integer userId) {
//		try {
//			BaseResponse<List<NonStandardValueVo>> e = inonStandardValueService.getByUserId(userId);
//			if (e == null) {
//				return BaseResponse.errorMsg("信息错误!");
//			}
//			return BaseResponse.okData(e);
//		} catch (Exception e) {
//			log.debug("通过用户id查询非标产值信息{}", e);
//		}
//		return BaseResponse.errorMsg("失败!");
//	}

	@ApiOperation("非标产值信息导出列表")
	@PostMapping("/exportList")
	public void exportList(String filename, Integer userId, String name, HttpServletResponse response) {
		try {
			inonStandardValueService.exportList(filename, userId, name, response);
		} catch (Exception e) {
			log.debug("非标产值信息导出列表{}", e);
		}
	}
}
