package cn.wise.sc.cement.business.controller;

import cn.wise.sc.cement.business.model.BaseResponse;
import cn.wise.sc.cement.business.model.PageQuery;
import cn.wise.sc.cement.business.model.query.PlanPeopleQuery;
import cn.wise.sc.cement.business.model.query.SampleDistributionEnclosureQuery;
import cn.wise.sc.cement.business.service.IPlanPeopleService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * <p>
 * 前端控制器
 * </p>
 *
 * @author wlb
 * @since 2020-10-19
 */
@Api(tags = "计划管理-培训计划审批")
@RestController
@RequestMapping("/tcdri/plan_people")
public class PlanPeopleController {
	private static final Logger log = LoggerFactory.getLogger("PlanPeopleController");

	@Autowired
	private IPlanPeopleService iPlanPeopleService;

	@ApiOperation(value = "培训计划审批分页")
	@GetMapping("/getPage")
	public BaseResponse getPage(PageQuery pageQuery, Integer planId) {
		try {
			return iPlanPeopleService.getPage(pageQuery, planId);
		} catch (Exception e) {
			log.debug("培训计划分页{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "获取所有的培训计划审批")
	@GetMapping("/getList")
	public BaseResponse getList() {
		try {
			return iPlanPeopleService.getList();
		} catch (Exception e) {
			log.debug("获取指定时间内的培训计划{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "考核结果")
	@PostMapping("/status")
	public BaseResponse status(Integer status, Integer id) {
		try {
			return iPlanPeopleService.status(status, id);
		} catch (Exception e) {
			log.debug("审批操作实现{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "培训计划上传附件")
	@PostMapping("/uploadPlanPF")
	public BaseResponse uploadPlanPF(PlanPeopleQuery query) {
		try {
			return iPlanPeopleService.uploadPlanPF(query);
		} catch (Exception e) {
			log.debug("培训计划上传附件{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "同步历史档案")
	@PostMapping("/synchronization/{id}")
	public BaseResponse synchronization(@PathVariable Integer id) {
		try {
			return iPlanPeopleService.synchronization(id);
		} catch (Exception e) {
			log.debug("同步历史档案{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}
}
