package cn.wise.sc.cement.business.controller;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import cn.wise.sc.cement.business.model.BaseResponse;
import cn.wise.sc.cement.business.model.PageQuery;
import cn.wise.sc.cement.business.model.query.PlanTrainingQuery;
import cn.wise.sc.cement.business.model.vo.PlanTrainingVo;
import cn.wise.sc.cement.business.service.IPlanTrainingService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.Date;
import java.util.List;

/**
 * <p>
 * 前端控制器
 * </p>
 *
 * @author wlb
 * @since 2020-10-19
 */
@Api(tags = "计划管理-培训计划")
@RestController
@RequestMapping("/tcdri/plan_training")
public class PlanTrainingController {
	private static final Logger log = LoggerFactory.getLogger("PlanTrainingController");

	@Autowired
	private IPlanTrainingService iplanTrainingService;

	@ApiOperation(value = "培训计划分页")
	@GetMapping("/getPage")
	public BaseResponse getPage(PageQuery pageQuery) {
		try {
			return iplanTrainingService.getPage(pageQuery);
		} catch (Exception e) {
			log.debug("培训计划分页{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "获取指定时间内的培训计划")
	@GetMapping("/getList")
	public BaseResponse getList(String start, String end) {
		Date startParse = null;
		if (StrUtil.isNotBlank(start)) {
			startParse = DateUtil.parse(start);
		}
		Date endParse = null;
		if (StrUtil.isNotBlank(end)) {
			endParse = DateUtil.parse(end);
		}
		try {
			return iplanTrainingService.getList(startParse, endParse);
		} catch (Exception e) {
			log.debug("获取指定时间内的培训计划{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "根据id查询指定培训计划")
	@GetMapping("/{id}")
	public BaseResponse getById(@PathVariable Integer id) {
		try {
			BaseResponse<List<PlanTrainingVo>> e = iplanTrainingService.getById(id);
			if (e == null) {
				return BaseResponse.errorMsg("信息错误!");
			}
			return BaseResponse.okData(e);
		} catch (Exception e) {
			log.debug("通过id查询培训计划{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "添加培训")
	@PostMapping("/create")
	public BaseResponse create(@RequestBody PlanTrainingQuery query) {
		if (query.getRemind() == 0 && query.getRemindTime() != null) {
			return BaseResponse.errorMsg("没有确认");
		}
		if (query.getRemind() == 1 && query.getRemindTime() == null) {
			return BaseResponse.errorMsg("请选择提醒时间");
		}
		try {
			return iplanTrainingService.create(query);
		} catch (Exception e) {
			log.debug("添加培训{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "修改培训计划")
	@PostMapping("/update")
	public BaseResponse update(@RequestBody PlanTrainingQuery planTrainingQuery) {
		if (planTrainingQuery.getRemind() == 0 && planTrainingQuery.getRemindTime() != null) {
			return BaseResponse.errorMsg("没有确认提醒");
		}
		if (planTrainingQuery.getRemind() == 1 && planTrainingQuery.getRemindTime() == null) {
			return BaseResponse.errorMsg("请选择提醒时间");
		}
		try {
			return iplanTrainingService.update(planTrainingQuery);
		} catch (Exception e) {
			log.debug("修改培训计划{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "培训计划是否开始")
	@PostMapping("/checkplanDate")
	public BaseResponse checkplanDate(){
		try{
			return iplanTrainingService.checkplanDate();
		}catch (Exception e){
			log.debug("培训计划是否开始{}",e);
		}
		return BaseResponse.errorMsg("失败!");
	}

//	@ApiOperation(value = "考核结果")
//	@PostMapping("/status")
//	public BaseResponse status(Integer status, Integer id){
//		try {
//			return iplanTrainingService.status(status, id);
//		}catch (Exception e){
//			log.debug("审批操作实现{}",e);
//		}
//		return BaseResponse.errorMsg("失败!");
//	}

	@ApiOperation(value = "删除培训信息")
	@PostMapping("/delete/{id}")
	public BaseResponse delete(@PathVariable Integer id) {
		try {
			return iplanTrainingService.delete(id);
		} catch (Exception e) {
			log.debug("删除培训信息{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation("培训计划导出")
	@PostMapping("/exportList")
	public void exportList(String filename,HttpServletResponse response) {
		try {
			iplanTrainingService.exportList(filename,response);
		} catch (Exception e) {
			log.debug("培训计划导出{}", e);
		}
	}

//	@ApiOperation(value = "上传培训计划附件")
//	@GetMapping("/uploadPlanTrainListPT")
//	public BaseResponse uploadPlanTrainListPT(PlanTrainingFJ query) {
//		try {
//			return iplanTrainingService.uploadPlanTrainListPT(query);
//		} catch (Exception e) {
//			log.debug("接受检测项目任务{}", e);
//		}
//		return BaseResponse.errorMsg("失败!");
//	}
}
