package cn.wise.sc.cement.business.controller;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import cn.wise.sc.cement.business.entity.QualityApply;
import cn.wise.sc.cement.business.model.BaseResponse;
import cn.wise.sc.cement.business.service.IQualityApplyService;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletResponse;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * <p>
 * 前端控制器
 * </p>
 *
 * @author ztw
 * @since 2020-10-12
 */
@Api(tags = "质量检测审批")
@Slf4j
@CrossOrigin
@RestController
@RequestMapping("/business/qualityApply")
public class QualityApplyController {

    final
    IQualityApplyService iQualityApplyService;

    public QualityApplyController(IQualityApplyService iQualityApplyService) {
        this.iQualityApplyService = iQualityApplyService;
    }

    @PostMapping("/apply")
    @ApiOperation("质量详情审核")
    public BaseResponse<Boolean> applyQuality(@RequestBody List<QualityApply> qualityApply) {

        Set<Integer> groupIds = qualityApply
                .stream().map(QualityApply::getTeamGroupId).collect(Collectors.toSet());
        QueryWrapper<QualityApply> qw = new QueryWrapper<>();
        Set<Integer> projectIds = qualityApply
                .stream().map(QualityApply::getProjectId).collect(Collectors.toSet());
        if (CollectionUtil.isEmpty(qualityApply) && CollectionUtil.isEmpty(groupIds)
                && CollectionUtil.isEmpty(projectIds)) {
            return BaseResponse.okData(true);
        }

        qw.eq("project_id", projectIds.iterator().next());
        qw.in("team_group_id", groupIds);
        iQualityApplyService.remove(qw);
        boolean save = iQualityApplyService.saveBatch(qualityApply);
        if (save) {
            return BaseResponse.okData(true);
        } else {
            return BaseResponse.errorMsg("添加失败!");
        }
    }

    @PostMapping("/export")
    @ApiOperation("导出质量监控")
    public void exportQuality(String startDate, String endDate, HttpServletResponse response) {

        Date startParse = null;
        if (StrUtil.isNotBlank(startDate)) {
            startParse = DateUtil.parse(startDate);
        }
        Date endParse = null;
        if (StrUtil.isNotBlank(endDate)) {
            endParse = DateUtil.parse(endDate);
        }
        iQualityApplyService.exportQuality(startParse, endParse, response);
    }
}

