package cn.wise.sc.cement.business.controller;

import cn.hutool.core.collection.CollectionUtil;
import cn.wise.sc.cement.business.entity.Consumables;
import cn.wise.sc.cement.business.entity.GroupStandard;
import cn.wise.sc.cement.business.entity.Standard;
import cn.wise.sc.cement.business.model.BaseResponse;
import cn.wise.sc.cement.business.model.PageQuery;
import cn.wise.sc.cement.business.model.query.ChangeStockQuery;
import cn.wise.sc.cement.business.model.query.ChangeValidDateQuery;
import cn.wise.sc.cement.business.model.query.StandardQuery;
import cn.wise.sc.cement.business.model.vo.StandardValueVo;
import cn.wise.sc.cement.business.service.IStandardService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.List;

/**
 * <p>
 * 前端控制器
 * </p>
 *
 * @author ztw
 * @since 2020-09-04
 */
@Api(tags = "资源管理-标样管理")
@RestController
@RequestMapping("/business/standard")
public class StandardController {

    private static final Logger log = LoggerFactory.getLogger("StandardController");

    @Autowired
    private IStandardService standardService;

    @ApiOperation(value = "标样分页列表")
    @ApiImplicitParams(value = {
            @ApiImplicitParam(name = "name", value = "易耗品名称", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = "supplierName", value = "购买厂商名称", paramType = "query", dataType = "String")
    })
    @GetMapping("/getPage")
    public BaseResponse getPage(PageQuery pageQuery, String name, String supplierName) {
        try {
            return standardService.getPage(pageQuery, name, supplierName);
        } catch (Exception e) {
            log.debug("标样分页列表{}", e);
        }
        return BaseResponse.errorMsg("失败!");
    }

    @ApiOperation("标样信息列表导出")
    @PostMapping("/export")
    public void export(String name, String supplierName, String fileName, HttpServletResponse response) {
        try {
            standardService.export(name, supplierName, fileName, response);
        } catch (Exception e) {
            log.debug("标样信息列表导出{}", e);
        }
    }

    @ApiOperation(value = "新增标样")
    @PostMapping("/create")
    public BaseResponse create(@RequestBody StandardQuery query) {
        try {
            return standardService.create(query);
        } catch (Exception e) {
            log.debug("新增标样{}", e);
        }
        return BaseResponse.errorMsg("失败!");
    }

    @ApiOperation(value = "修改标样")
    @PostMapping("/update")
    public BaseResponse update(@RequestBody StandardQuery query) {
        try {
            return standardService.update(query);
        } catch (Exception e) {
            log.debug("修改标样{}", e);
        }
        return BaseResponse.errorMsg("失败!");
    }

    @ApiOperation(value = "查看历史标样材料信息")
    @GetMapping("/getHistoryStandard/{id}")
    public BaseResponse getHistoryStandard(@PathVariable Integer id) {
        try {
            return standardService.getHistoryStandard(id);
        } catch (Exception e) {
            log.debug("查看历史标样材料信息{}", e);
        }
        return BaseResponse.errorMsg("失败!");
    }

    @ApiOperation(value = "标样详情")
    @GetMapping("/{id}")
    public BaseResponse getById(@PathVariable Integer id) {
        try {
            return standardService.getDetail(id);
        } catch (Exception e) {
            log.debug("标样详情{}", e);
        }
        return BaseResponse.errorMsg("失败!");
    }

    @ApiOperation(value = "标样列表")
    @GetMapping("/getList")
    public BaseResponse getList() {
        try {
            List<Standard> list = standardService.list();
            return BaseResponse.okData(list);
        } catch (Exception e) {
            log.debug("标样列表{}", e);
        }
        return BaseResponse.errorMsg("失败!");
    }

    @ApiOperation(value = "删除标样")
    @PostMapping("/delete/{id}")
    public BaseResponse delete(@PathVariable Integer id) {
        try {
            standardService.removeById(id);
            return BaseResponse.okData("删除成功");
        } catch (Exception e) {
            log.debug("删除标样{}", e);
        }
        return BaseResponse.errorMsg("失败!");
    }

    @ApiOperation(value = "新增入库")
    @PostMapping("/enter")
    public BaseResponse enter(@RequestBody ChangeStockQuery query) {
        try {
            return standardService.enter(query);
        } catch (Exception e) {
            log.debug("新增入库{}", e);
        }
        return BaseResponse.errorMsg("失败!");
    }

    @ApiOperation(value = "领用出库")
    @PostMapping("/out")
    public BaseResponse out(@RequestBody ChangeStockQuery query) {
        try {
            return standardService.out(query);
        } catch (Exception e) {
            log.debug("领用出库{}", e);
        }
        return BaseResponse.errorMsg("失败!");
    }

    @ApiOperation(value = "变更有效期")
    @PostMapping("/changeValidDate")
    public BaseResponse changeValidDate(@RequestBody ChangeValidDateQuery query) {
        try {
            return standardService.changeValidDate(query);
        } catch (Exception e) {
            log.debug("变更有效期{}", e);
        }
        return BaseResponse.errorMsg("失败!");
    }

    @ApiOperation(value = "过期处置")
    @PostMapping("/overdue")
    public BaseResponse overdue(Integer id) {
        try {
            return standardService.overdue(id);
        } catch (Exception e) {
            log.debug("过期处置{}", e);
        }
        return BaseResponse.errorMsg("失败!");
    }

    @ApiOperation("获取样本标准值列表")
    @GetMapping("/detailList")
    public BaseResponse<List<StandardValueVo>> getStandardDetailList() {
        return standardService.getStandardDetailList();
    }

    @ApiOperation("按检测组获取标样信息")
    @GetMapping("/list/byGroup")
    public BaseResponse<List<GroupStandard>> getStandards(String name) {

        return BaseResponse.okData(standardService.getStandards(name));
    }
}

