package cn.wise.sc.cement.business.controller;

import cn.wise.sc.cement.business.entity.SysGroup;
import cn.wise.sc.cement.business.entity.SysRole;
import cn.wise.sc.cement.business.entity.SysUser;
import cn.wise.sc.cement.business.model.BaseResponse;
import cn.wise.sc.cement.business.model.PageQuery;
import cn.wise.sc.cement.business.model.query.RoleQuery;
import cn.wise.sc.cement.business.service.ISysGroupService;
import cn.wise.sc.cement.business.service.ISysUserService;
import cn.wise.sc.cement.business.wrapper.page.Query;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 * 前端控制器
 * </p>
 *
 * @author ztw
 * @since 2020-08-21
 */
@Api(tags = "系统管理-工作组管理")
@RestController
@RequestMapping("/business/sys-group")
public class SysGroupController {

	private static final Logger log = LoggerFactory.getLogger("SysGroupController");

	@Autowired
	private ISysGroupService groupService;
	@Autowired
	private ISysUserService userService;

	@ApiOperation(value = "工作组分页列表")
	@GetMapping("/getPage")
	public BaseResponse getPage(PageQuery pageQuery) {
		try {
			return groupService.getPage(pageQuery);
		} catch (Exception e) {
			log.debug("工作组分页列表{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "新增工作组")
	@PostMapping("/create")
	public BaseResponse create(@RequestBody SysGroup query) {
		try {
			return groupService.create(query);
		} catch (Exception e) {
			log.debug("新增工作组{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "修改工作组")
	@PostMapping("/update")
	public BaseResponse update(@RequestBody SysGroup query) {
		try {
			return groupService.update(query);
		} catch (Exception e) {
			log.debug("修改工作组{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "工作组详情")
	@GetMapping("/{id}")
	public BaseResponse getById(@PathVariable Integer id) {
		try {
			SysGroup group = groupService.getById(id);
			if (group == null) {
				return BaseResponse.errorMsg("信息错误!");
			}
			return BaseResponse.okData(group);
		} catch (Exception e) {
			log.debug("工作组详情{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "工作组列表")
	@GetMapping("/getList")
	public BaseResponse getById() {
		try {
			List<SysGroup> list = groupService.list();
			return BaseResponse.okData(list);
		} catch (Exception e) {
			log.debug("工作组列表{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "删除工作组")
	@PostMapping("/delete/{id}")
	public BaseResponse delete(@PathVariable Integer id) {
		try {
			if(id == 1 || id == 2){
				return BaseResponse.errorMsg("工作组不允许删除!");
			}
			QueryWrapper<SysUser> sysUserQueryWrapper = new QueryWrapper<>();
			sysUserQueryWrapper.eq("group_id", id);
			Integer conunts = userService.count(sysUserQueryWrapper);
			if (conunts != 0 && conunts > 0) {
				return BaseResponse.errorMsg(conunts + "个用户正在使用!");
			}
			groupService.removeById(id);
			return BaseResponse.okData("删除成功");
		} catch (Exception e) {
			log.debug("删除工作组{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}

}

