package cn.wise.sc.cement.business.controller;

import cn.wise.sc.cement.business.model.BaseResponse;
import cn.wise.sc.cement.business.model.PageQuery;
import cn.wise.sc.cement.business.service.ISysLogsService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;

import org.springframework.web.bind.annotation.RestController;

/**
 * <p>
 * 前端控制器
 * </p>
 *
 * @author ztw
 * @since 2020-08-24
 */
@Api(tags = "系统管理-日志管理")
@RestController
@RequestMapping("/business/sys-logs")
public class SysLogsController {

	private static final Logger log = LoggerFactory.getLogger("SysLogsController");

	@Autowired
	private ISysLogsService logsService;

	@ApiOperation(value = "日志分页列表")
	@ApiImplicitParams(value = {
			@ApiImplicitParam(name = "startDate", value = "开始日期", paramType = "query", dataType = "String"),
			@ApiImplicitParam(name = "endDate", value = "结束日期", paramType = "query", dataType = "String"),
			@ApiImplicitParam(name = "objType", value = "日志类型(0系统日志, 1委托管理)", paramType = "query", dataType = "Integer"),
			@ApiImplicitParam(name = "objId", value = "对象表id", paramType = "query", dataType = "Integer")
	})
	@GetMapping("/getPage")
	public BaseResponse getPage(PageQuery pageQuery, String startDate, String endDate, Integer objType, Integer objId) {
		try {
			return logsService.getPage(pageQuery, startDate, endDate, objType, objId);
		} catch (Exception e) {
			log.debug("日志分页列表{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}

}

