package cn.wise.sc.cement.business.controller;

import cn.wise.sc.cement.business.entity.SysGroup;
import cn.wise.sc.cement.business.entity.SysPost;
import cn.wise.sc.cement.business.entity.SysUser;
import cn.wise.sc.cement.business.model.BaseResponse;
import cn.wise.sc.cement.business.model.PageQuery;
import cn.wise.sc.cement.business.model.query.PostQuery;
import cn.wise.sc.cement.business.service.ISysPostService;
import cn.wise.sc.cement.business.service.ISysUserService;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 * 前端控制器
 * </p>
 *
 * @author ztw
 * @since 2020-08-25
 */
@Api(tags = "系统管理-职务管理")
@RestController
@RequestMapping("/business/sys-post")
public class SysPostController {

	private static final Logger log = LoggerFactory.getLogger("SysPostController");

	@Autowired
	private ISysPostService postService;
	@Autowired
	private ISysUserService userService;

	@ApiOperation(value = "职务分页列表")
	@ApiImplicitParams(value = {
			@ApiImplicitParam(name = "name", value = "职务名称", paramType = "query", dataType = "String")
	})
	@GetMapping("/getPage")
	public BaseResponse getPage(PageQuery pageQuery, String name) {
		try {
			return postService.getPage(pageQuery, name);
		} catch (Exception e) {
			log.debug("职务分页列表{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "新增职务")
	@PostMapping("/create")
	public BaseResponse create(@RequestBody PostQuery query) {
		try {
			return postService.create(query);
		} catch (Exception e) {
			log.debug("新增职务{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "修改职务")
	@PostMapping("/update")
	public BaseResponse update(@RequestBody PostQuery query) {
		try {
			return postService.update(query);
		} catch (Exception e) {
			log.debug("修改职务{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "职务详情")
	@GetMapping("/{id}")
	public BaseResponse getById(@PathVariable Integer id) {
		try {
			SysPost post = postService.getById(id);
			if (post == null) {
				return BaseResponse.errorMsg("信息错误!");
			}
			return BaseResponse.okData(post);
		} catch (Exception e) {
			log.debug("职务详情{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "职务列表")
	@GetMapping("/getList")
	public BaseResponse getList() {
		try {
			List<SysPost> list = postService.list();
			return BaseResponse.okData(list);
		} catch (Exception e) {
			log.debug("职务列表{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "删除职务")
	@PostMapping("/delete/{id}")
	public BaseResponse delete(@PathVariable Integer id) {
		try {
			if(id == 1 || id == 2){
				return BaseResponse.errorMsg("职务不允许删除!");
			}
			QueryWrapper<SysUser> sysUserQueryWrapper = new QueryWrapper<>();
			sysUserQueryWrapper.eq("post_id", id);
			Integer conunts = userService.count(sysUserQueryWrapper);
			if (conunts != 0 && conunts > 0) {
				return BaseResponse.errorMsg(conunts + "个用户正在使用!");
			}
			postService.removeById(id);
			return BaseResponse.okData("删除成功");
		} catch (Exception e) {
			log.debug("删除职务{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}

}

