package cn.wise.sc.cement.business.controller;

import cn.wise.sc.cement.business.entity.Client;
import cn.wise.sc.cement.business.entity.SysUser;
import cn.wise.sc.cement.business.model.BaseResponse;
import cn.wise.sc.cement.business.model.LoginUser;
import cn.wise.sc.cement.business.model.PageQuery;
import cn.wise.sc.cement.business.model.query.SysUserEnclosureQuery;
import cn.wise.sc.cement.business.model.query.UserQuery;
import cn.wise.sc.cement.business.model.vo.ProjectVo;
import cn.wise.sc.cement.business.service.ISysUserService;
import cn.wise.sc.cement.business.wrapper.WrapMapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * <p>
 * 前端控制器
 * </p>
 *
 * @author ztw
 * @since 2020-08-14
 */
@Api(tags = "系统管理-人员管理")
@RestController
@RequestMapping("/tcdri/sys-user")
public class SysUserController {

	private static final Logger log = LoggerFactory.getLogger("SysUserController");

	@Autowired
	private ISysUserService userService;

	@ApiOperation(value = "人员分页列表")
	@ApiImplicitParams(value = {
			@ApiImplicitParam(name = "status", value = "状态0:禁用 1:启用", paramType = "query", dataType = "Integer"),
			@ApiImplicitParam(name = "groupId", value = "工作组id", paramType = "query", dataType = "Integer"),
			@ApiImplicitParam(name = "name", value = "姓名", paramType = "query", dataType = "String")
	})
	@GetMapping("/getPage")
	public BaseResponse getPage(PageQuery pageQuery, Integer status, Integer groupId, String name) {
		try {
			return userService.getPage(pageQuery, status, groupId, name);
		} catch (Exception e) {
			log.debug("人员分页列表{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "新增人员")
	@PostMapping("/create")
	public BaseResponse create(@RequestBody UserQuery query) {
		try {
			return userService.create(query);
		} catch (Exception e) {
			log.debug("新增人员{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "更新人员")
	@PostMapping("/update")
	public BaseResponse update(@RequestBody UserQuery query) {
		try {
			return userService.update(query);
		} catch (Exception e) {
			log.debug("更新人员{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "启用禁用")
	@PostMapping("/status")
	public BaseResponse status(Integer status, Integer id) {
		try {
			return userService.status(status, id);
		} catch (Exception e) {
			log.debug("启用禁用{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "人员详情")
	@GetMapping("/{id}")
	public BaseResponse getById(@PathVariable Integer id) {
		try {
			return userService.findById(id);
		} catch (Exception e) {
			log.debug("人员详情{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "人员列表")
	@GetMapping("/getList")
	public BaseResponse getList() {
		try {
			LoginUser loginUser = userService.getLoginUser();
			QueryWrapper<SysUser> queryWrapper = new QueryWrapper<>();
			if(loginUser != null && loginUser.getGroupId() != null){
				queryWrapper.eq("group_id", loginUser.getGroupId());
			}
			List<SysUser> list = userService.list(queryWrapper);
			return BaseResponse.okData(list);
		} catch (Exception e) {
			log.debug("人员列表{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "上传附件")
	@PostMapping("/uploadPeoplePF")
	public BaseResponse uploadPeoplePF(@RequestBody SysUserEnclosureQuery query){
		try {
			return userService.uploadPeoplePF(query);
		}catch (Exception e){
			log.debug("上传附件{}",e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "附件分页列表")
	@GetMapping("/getUserEnclosurePage")
	public BaseResponse getUserEnclosurePage(PageQuery pageQuery, Integer userId) {
		try {
			return userService.getUserEnclosurePage(pageQuery, userId);
		} catch (Exception e) {
			log.debug("附件分页列表{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "删除人员附件")
	@PostMapping("/deleteUserEnclosure")
	public BaseResponse deleteUserEnclosure(Integer id) {
		try {
			return userService.deleteUserEnclosure(id);
		} catch (Exception e) {
			log.debug("删除人员附件{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}





//	@ApiOperation("人员详情导出列表")
//	@PostMapping("/exportList")
//	public void exportList(Integer status,String filename,String name, HttpServletResponse response) {
//		try {
//			userService.exportList(status, filename,name, response);
//		} catch (Exception e) {
//			log.debug("人员详情导出列表{}", e);
//		}
//	}

}

