package cn.wise.sc.cement.business.controller;

import cn.wise.sc.cement.business.model.BaseResponse;
import cn.wise.sc.cement.business.service.ISysUserMessageService;
import cn.wise.sc.cement.business.wrapper.WrapMapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;

import org.springframework.web.bind.annotation.RestController;

/**
 * <p>
 * 前端控制器
 * </p>
 *
 * @author ztw
 * @since 2020-10-13
 */
@Api(tags = "企业微信移动端-消息管理")
@RestController
@RequestMapping("/business/sys-user-message")
public class SysUserMessageController {

	private static final Logger log = LoggerFactory.getLogger("SysUserMessageController");

	@Autowired
	private ISysUserMessageService userMessageService;

	@ApiOperation(value = "消息通知列表")
	@GetMapping("/getMessages")
	public BaseResponse getMessages() {
		try {
			return userMessageService.getMessages();
		} catch (Exception e) {
			log.debug("消息通知列表{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}

}

