package cn.wise.sc.cement.business.entity;

import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 国标爬虫表
 * </p>
 *
 * @author ztw
 * @since 2020-12-09
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class Chinastd implements Serializable {

    private static final long serialVersionUID=1L;

    /**
     * 国标号
     */
    @TableId(type = IdType.INPUT)
    private String code;

    /**
     * 名字
     */
    private String title;

    /**
     * 标准类型: 行业标准/国家标准
     */
    private String stdtype;

    /**
     * 状态: 现行/废止
     */
    private String status;

    /**
     * 颁布时间
     */
    private String publictime;

    /**
     * 0:实验室未使用，1实验室使用
     */
    private Boolean inuse;

    /**
     * 执行时间
     */
    private String starttime;


}
